/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.strtree;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.AbstractNode;
import com.vividsolutions.jts.index.strtree.AbstractSTRtree;
import com.vividsolutions.jts.index.strtree.Boundable;
import com.vividsolutions.jts.index.strtree.BoundablePair;
import com.vividsolutions.jts.index.strtree.ItemBoundable;
import com.vividsolutions.jts.index.strtree.ItemDistance;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jts.util.PriorityQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class STRtree
extends AbstractSTRtree
implements SpatialIndex,
Serializable {
    private static final long serialVersionUID = 259274702368956900L;
    private static Comparator xComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return STRtree.compareDoubles(STRtree.centreX((Envelope)((Boundable)o1).getBounds()), STRtree.centreX((Envelope)((Boundable)o2).getBounds()));
        }
    };
    private static Comparator yComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return STRtree.compareDoubles(STRtree.centreY((Envelope)((Boundable)o1).getBounds()), STRtree.centreY((Envelope)((Boundable)o2).getBounds()));
        }
    };
    private static AbstractSTRtree.IntersectsOp intersectsOp = new AbstractSTRtree.IntersectsOp(){

        public boolean intersects(Object aBounds, Object bBounds) {
            return ((Envelope)aBounds).intersects((Envelope)bBounds);
        }
    };
    private static final int DEFAULT_NODE_CAPACITY = 10;

    private static double centreX(Envelope e) {
        return STRtree.avg(e.getMinX(), e.getMaxX());
    }

    private static double centreY(Envelope e) {
        return STRtree.avg(e.getMinY(), e.getMaxY());
    }

    private static double avg(double a, double b) {
        return (a + b) / 2.0;
    }

    protected List createParentBoundables(List childBoundables, int newLevel) {
        Assert.isTrue(!childBoundables.isEmpty());
        int minLeafCount = (int)Math.ceil((double)childBoundables.size() / (double)this.getNodeCapacity());
        ArrayList sortedChildBoundables = new ArrayList(childBoundables);
        Collections.sort(sortedChildBoundables, xComparator);
        List[] verticalSlices = this.verticalSlices(sortedChildBoundables, (int)Math.ceil(Math.sqrt(minLeafCount)));
        return this.createParentBoundablesFromVerticalSlices(verticalSlices, newLevel);
    }

    private List createParentBoundablesFromVerticalSlices(List[] verticalSlices, int newLevel) {
        Assert.isTrue(verticalSlices.length > 0);
        ArrayList parentBoundables = new ArrayList();
        int i = 0;
        while (i < verticalSlices.length) {
            parentBoundables.addAll(this.createParentBoundablesFromVerticalSlice(verticalSlices[i], newLevel));
            ++i;
        }
        return parentBoundables;
    }

    protected List createParentBoundablesFromVerticalSlice(List childBoundables, int newLevel) {
        return super.createParentBoundables(childBoundables, newLevel);
    }

    protected List[] verticalSlices(List childBoundables, int sliceCount) {
        int sliceCapacity = (int)Math.ceil((double)childBoundables.size() / (double)sliceCount);
        List[] slices = new List[sliceCount];
        Iterator i = childBoundables.iterator();
        int j = 0;
        while (j < sliceCount) {
            slices[j] = new ArrayList();
            int boundablesAddedToSlice = 0;
            while (i.hasNext() && boundablesAddedToSlice < sliceCapacity) {
                Boundable childBoundable = (Boundable)i.next();
                slices[j].add(childBoundable);
                ++boundablesAddedToSlice;
            }
            ++j;
        }
        return slices;
    }

    public STRtree() {
        this(10);
    }

    public STRtree(int nodeCapacity) {
        super(nodeCapacity);
    }

    protected AbstractNode createNode(int level) {
        return new STRtreeNode(level);
    }

    protected AbstractSTRtree.IntersectsOp getIntersectsOp() {
        return intersectsOp;
    }

    public void insert(Envelope itemEnv, Object item) {
        if (itemEnv.isNull()) {
            return;
        }
        super.insert(itemEnv, item);
    }

    public List query(Envelope searchEnv) {
        return super.query(searchEnv);
    }

    public void query(Envelope searchEnv, ItemVisitor visitor) {
        super.query(searchEnv, visitor);
    }

    public boolean remove(Envelope itemEnv, Object item) {
        return super.remove(itemEnv, item);
    }

    public int size() {
        return super.size();
    }

    public int depth() {
        return super.depth();
    }

    protected Comparator getComparator() {
        return yComparator;
    }

    public Object[] nearestNeighbour(ItemDistance itemDist) {
        BoundablePair bp = new BoundablePair(this.getRoot(), this.getRoot(), itemDist);
        return this.nearestNeighbour(bp);
    }

    public Object nearestNeighbour(Envelope env, Object item, ItemDistance itemDist) {
        ItemBoundable bnd = new ItemBoundable(env, item);
        BoundablePair bp = new BoundablePair(this.getRoot(), bnd, itemDist);
        return this.nearestNeighbour(bp)[0];
    }

    public Object[] nearestNeighbour(STRtree tree, ItemDistance itemDist) {
        BoundablePair bp = new BoundablePair(this.getRoot(), tree.getRoot(), itemDist);
        return this.nearestNeighbour(bp);
    }

    private Object[] nearestNeighbour(BoundablePair initBndPair) {
        return this.nearestNeighbour(initBndPair, Double.POSITIVE_INFINITY);
    }

    private Object[] nearestNeighbour(BoundablePair initBndPair, double maxDistance) {
        double distanceLowerBound = maxDistance;
        BoundablePair minPair = null;
        PriorityQueue priQ = new PriorityQueue();
        priQ.add(initBndPair);
        while (!priQ.isEmpty() && distanceLowerBound > 0.0) {
            BoundablePair bndPair = (BoundablePair)priQ.poll();
            double currentDistance = bndPair.getDistance();
            if (currentDistance >= distanceLowerBound) break;
            if (bndPair.isLeaves()) {
                distanceLowerBound = currentDistance;
                minPair = bndPair;
                continue;
            }
            bndPair.expandToQueue(priQ, distanceLowerBound);
        }
        return new Object[]{((ItemBoundable)minPair.getBoundable(0)).getItem(), ((ItemBoundable)minPair.getBoundable(1)).getItem()};
    }

    private static final class STRtreeNode
    extends AbstractNode {
        private STRtreeNode(int level) {
            super(level);
        }

        protected Object computeBounds() {
            Envelope bounds = null;
            for (Boundable childBoundable : this.getChildBoundables()) {
                if (bounds == null) {
                    bounds = new Envelope((Envelope)childBoundable.getBounds());
                    continue;
                }
                bounds.expandToInclude((Envelope)childBoundable.getBounds());
            }
            return bounds;
        }
    }
}

