/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl.jtsext.geom;

import ch.interlis.iom_j.itf.impl.hrg.HrgUtility;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequences;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;

public class ArcSegment
extends CurveSegment {
    private Coordinate startPoint = null;
    private Coordinate midPoint = null;
    private Coordinate endPoint = null;
    private Coordinate centerPoint = null;
    private Coordinate[] ret = null;
    private static final double EPSILON = 1.0E-8;
    private final double P;
    double radius;
    double sign = 0.0;
    double deta = 0.0;

    public ArcSegment(Object userData, Coordinate startPoint, Coordinate midPoint, Coordinate endPoint, double p) {
        this.P = p;
        this.userData = userData;
        this.startPoint = new Coordinate(startPoint);
        this.midPoint = new Coordinate(midPoint);
        this.endPoint = new Coordinate(endPoint);
        if (this.midPoint.z == Double.NaN && this.endPoint.z != Double.NaN) {
            this.midPoint.z = (this.endPoint.z + this.startPoint.z) / 2.0;
        }
    }

    public ArcSegment(Object userData, Coordinate startPoint, Coordinate midPoint, Coordinate endPoint) {
        this(userData, startPoint, midPoint, endPoint, 0.001);
    }

    public ArcSegment(Coordinate startPoint, Coordinate midPoint, Coordinate endPoint) {
        this(null, startPoint, midPoint, endPoint);
    }

    public ArcSegment(Coordinate startPoint, Coordinate midPoint, Coordinate endPoint, double p) {
        this(null, startPoint, midPoint, endPoint, p);
    }

    @Override
    public Coordinate getEndPoint() {
        return this.endPoint;
    }

    public Coordinate getNormalizedEndPoint() {
        return this.isArcNormalized() ? this.endPoint : this.startPoint;
    }

    @Override
    public Coordinate getStartPoint() {
        return this.startPoint;
    }

    public Coordinate getNormalizedStartPoint() {
        return this.isArcNormalized() ? this.startPoint : this.endPoint;
    }

    public Coordinate getMidPoint() {
        return this.midPoint;
    }

    private static Coordinate[] arc2straight(Coordinate startPoint, Coordinate midPoint, Coordinate endPoint, double radius, Coordinate centerPoint, double sign, double deta, double p) {
        CoordinateList ret = new CoordinateList();
        Coordinate p1 = null;
        p1 = startPoint;
        double pt1_re = p1.x;
        double pt1_ho = p1.y;
        double arcPt_re = midPoint.x;
        double arcPt_ho = midPoint.y;
        double pt2_re = endPoint.x;
        double pt2_ho = endPoint.y;
        double a = CurveSegment.dist(pt1_re, pt1_ho, arcPt_re, arcPt_ho);
        double b = CurveSegment.dist(arcPt_re, arcPt_ho, pt2_re, pt2_ho);
        double r = radius;
        double thetaM = deta;
        double reM = centerPoint.x;
        double hoM = centerPoint.y;
        double theta = 2.0 * Math.acos(1.0 - p / Math.abs(r));
        ret.add((Object)new Coordinate(pt1_re, pt1_ho));
        if (sign == 0.0 || p == 0.0) {
            ret.add((Object)new Coordinate(arcPt_re, arcPt_ho));
        } else {
            double pti_ho;
            double pti_re;
            int i;
            double ri;
            if (a > 2.0 * p) {
                double alpha = 2.0 * Math.asin(a / 2.0 / Math.abs(r));
                int alphan = (int)Math.ceil(alpha / theta);
                double alphai = alpha / ((double)alphan * sign);
                ri = Math.atan2(pt1_re - reM, pt1_ho - hoM);
                for (i = 1; i < alphan; ++i) {
                    pti_re = reM + Math.abs(r) * Math.sin(ri += alphai);
                    pti_ho = hoM + Math.abs(r) * Math.cos(ri);
                    ret.add((Object)new Coordinate(pti_re, pti_ho));
                }
            }
            ret.add((Object)new Coordinate(arcPt_re, arcPt_ho));
            if (b > 2.0 * p) {
                double beta = 2.0 * Math.asin(b / 2.0 / Math.abs(r));
                int betan = (int)Math.ceil(beta / theta);
                double betai = beta / ((double)betan * sign);
                ri = Math.atan2(arcPt_re - reM, arcPt_ho - hoM);
                for (i = 1; i < betan; ++i) {
                    pti_re = reM + Math.abs(r) * Math.sin(ri += betai);
                    pti_ho = hoM + Math.abs(r) * Math.cos(ri);
                    ret.add((Object)new Coordinate(pti_re, pti_ho));
                }
            }
        }
        ret.add((Object)new Coordinate(pt2_re, pt2_ho));
        return ret.toCoordinateArray();
    }

    @Override
    public Coordinate[] getCoordinates() {
        if (this.ret == null) {
            this.getCenterPoint();
            if (this.isArcNormalized()) {
                Coordinate[] ret = ArcSegment.arc2straight(this.startPoint, this.midPoint, this.endPoint, this.radius, this.centerPoint, this.sign, this.deta, this.P);
                this.ret = ret;
            } else {
                Coordinate[] ret = ArcSegment.arc2straight(this.endPoint, this.midPoint, this.startPoint, this.radius, this.centerPoint, -this.sign, this.deta, this.P);
                CoordinateArraySequence tmp = new CoordinateArraySequence(ret);
                CoordinateSequences.reverse((CoordinateSequence)tmp);
                this.ret = tmp.toCoordinateArray();
            }
        }
        return this.ret;
    }

    public Coordinate getCenterPoint() {
        if (this.centerPoint == null) {
            double[] Z1O = new double[1];
            double[] Z2O = new double[1];
            double[] DETAO = new double[1];
            double[] SIGNO = new double[1];
            if (this.isArcNormalized()) {
                HrgUtility.CTRC3P(this.startPoint.x, this.startPoint.y, this.midPoint.x, this.midPoint.y, this.endPoint.x, this.endPoint.y, Z1O, Z2O, DETAO, SIGNO);
                this.centerPoint = new Coordinate(Z1O[0], Z2O[0]);
                this.sign = SIGNO[0];
                this.deta = DETAO[0];
                this.radius = CurveSegment.dist(this.startPoint.x, this.startPoint.y, this.centerPoint.x, this.centerPoint.y);
            } else {
                HrgUtility.CTRC3P(this.endPoint.x, this.endPoint.y, this.midPoint.x, this.midPoint.y, this.startPoint.x, this.startPoint.y, Z1O, Z2O, DETAO, SIGNO);
                this.centerPoint = new Coordinate(Z1O[0], Z2O[0]);
                this.sign = -SIGNO[0];
                this.deta = DETAO[0];
                this.radius = CurveSegment.dist(this.endPoint.x, this.endPoint.y, this.centerPoint.x, this.centerPoint.y);
            }
        }
        return this.centerPoint;
    }

    public boolean isArcNormalized() {
        return this.startPoint.compareTo((Object)this.endPoint) >= 0;
    }

    public double getRadius() {
        if (this.centerPoint == null) {
            this.getCenterPoint();
        }
        return this.radius;
    }

    public boolean isStraight() {
        if (this.centerPoint == null) {
            this.getCenterPoint();
        }
        return this.sign == 0.0 && this.deta == 0.0;
    }

    private boolean isFullCircle() {
        if (this.centerPoint == null) {
            this.getCenterPoint();
        }
        return this.sign == 0.0 && this.deta == Math.PI * 2;
    }

    @Override
    Envelope expandEnvelope(Envelope env) {
        env = super.expandEnvelope(env);
        Coordinate center = this.getCenterPoint();
        if (this.isStraight()) {
            return env;
        }
        if (this.isFullCircle()) {
            double radius = this.getRadius();
            env.expandToInclude(center.x - radius, center.y - radius);
            env.expandToInclude(center.x + radius, center.y + radius);
            return env;
        }
        Coordinate start = this.getStartPoint();
        Coordinate end = this.getEndPoint();
        double ALFA = HrgUtility.PSECOS(start.x, start.y, center.x, center.y, end.x, end.y);
        Coordinate[] axpts = new Coordinate[]{new Coordinate(center.x + this.radius, center.y), new Coordinate(center.x, center.y + this.radius), new Coordinate(center.x - this.radius, center.y), new Coordinate(center.x, center.y - this.radius)};
        for (int i = 0; i < axpts.length; ++i) {
            double BETA = HrgUtility.PSECOS(start.x, start.y, center.x, center.y, axpts[i].x, axpts[i].y);
            if (ALFA != BETA && Math.signum(BETA - ALFA) != this.sign) continue;
            env.expandToInclude(axpts[i].x, axpts[i].y);
        }
        return env;
    }

    public String toString() {
        return "CIRCULARSTRING (" + this.startPoint.x + " " + this.startPoint.y + ", " + this.midPoint.x + " " + this.midPoint.y + ", " + this.endPoint.x + " " + this.endPoint.y + ")";
    }

    public double getSign() {
        if (this.centerPoint == null) {
            this.getCenterPoint();
        }
        return this.sign;
    }

    public double getNormalizedSign() {
        return this.isArcNormalized() ? this.getSign() : -this.getSign();
    }

    public double getTheta() {
        if (this.centerPoint == null) {
            this.getCenterPoint();
        }
        return this.deta;
    }

    public Coordinate getDirectionPt(boolean atStart, double dist) {
        if (dist > 0.0) {
            double radius = this.getRadius();
            Coordinate center = this.getCenterPoint();
            if (atStart) {
                if (dist / 2.0 > Math.abs(radius) || dist > CurveSegment.dist(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y)) {
                    return this.endPoint;
                }
                double alpha = 2.0 * Math.asin(dist / 2.0 / Math.abs(radius));
                double ri = Math.atan2(this.startPoint.x - center.x, this.startPoint.y - center.y);
                double pti_re = center.x + Math.abs(radius) * Math.sin(ri += alpha * this.sign);
                double pti_ho = center.y + Math.abs(radius) * Math.cos(ri);
                Coordinate directionPt = new Coordinate(pti_re, pti_ho);
                return directionPt;
            }
            if (dist / 2.0 > Math.abs(radius) || dist > CurveSegment.dist(this.endPoint.x, this.endPoint.y, this.startPoint.x, this.startPoint.y)) {
                return this.startPoint;
            }
            double alpha = 2.0 * Math.asin(dist / 2.0 / Math.abs(radius));
            double ri = Math.atan2(this.endPoint.x - center.x, this.endPoint.y - center.y) - alpha * this.sign;
            double pti_re = center.x + Math.abs(radius) * Math.sin(ri);
            double pti_ho = center.y + Math.abs(radius) * Math.cos(ri);
            Coordinate directionPt = new Coordinate(pti_re, pti_ho);
            return directionPt;
        }
        if (atStart) {
            Coordinate directionPt = CompoundCurve.calcKleinp(this.getCenterPoint(), this.startPoint, this.radius, 1.0 * -this.sign);
            return directionPt;
        }
        Coordinate directionPt = CompoundCurve.calcKleinp(this.getCenterPoint(), this.endPoint, this.radius, -1.0 * -this.sign);
        return directionPt;
    }

    public static Coordinate calcArcPt(Coordinate start, Coordinate end, Coordinate center, double radius, double sign) {
        double a = CurveSegment.dist(start.x, start.y, end.x, end.y);
        double alpha = Math.atan2(start.x - center.x, start.y - center.y) + sign * Math.asin(a / 2.0 / radius);
        Coordinate midPt = new Coordinate();
        midPt.x = center.x + radius * Math.sin(alpha);
        midPt.y = center.y + radius * Math.cos(alpha);
        return midPt;
    }

    public boolean isEquivalent(ArcSegment other) {
        if (!this.getNormalizedStartPoint().equals((Object)other.getNormalizedStartPoint())) {
            return false;
        }
        if (!this.getNormalizedEndPoint().equals((Object)other.getNormalizedEndPoint())) {
            return false;
        }
        if (Double.compare(this.getRadius(), other.getRadius()) != 0) {
            return false;
        }
        return Double.compare(this.getNormalizedSign(), other.getNormalizedSign()) == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.isEquivalent((ArcSegment)o);
    }

    public int hashCode() {
        int result = this.getNormalizedStartPoint().hashCode();
        result = 31 * result + this.getNormalizedEndPoint().hashCode();
        long temp = Double.doubleToLongBits(this.getRadius());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getNormalizedSign());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals2D(CurveSegment other, double tolerance) {
        boolean equalStartAndEnd;
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Coordinate startA = this.getStartPoint();
        Coordinate endA = this.getEndPoint();
        Coordinate startB = other.getStartPoint();
        Coordinate endB = other.getEndPoint();
        boolean bl = equalStartAndEnd = startA.equals2D(startB, tolerance) && endA.equals2D(endB, tolerance) || startA.equals2D(endB, tolerance) && endA.equals2D(startB, tolerance);
        if (!equalStartAndEnd) {
            return false;
        }
        ArcSegment otherArc = (ArcSegment)other;
        if (this.getNormalizedSign() != otherArc.getNormalizedSign()) {
            return false;
        }
        if (this.getMidPoint().equals2D(otherArc.getMidPoint(), tolerance)) {
            return true;
        }
        return this.calculateMidPoint().equals2D(otherArc.calculateMidPoint(), tolerance);
    }

    private Coordinate calculateMidPoint() {
        return ArcSegment.calcArcPt(this.getNormalizedStartPoint(), this.getNormalizedEndPoint(), this.getCenterPoint(), this.getRadius(), this.getNormalizedSign());
    }
}

