/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.sqlgen.generator_impl.jdbc;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.sqlgen.DbUtility;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbColBlob;
import ch.ehi.sqlgen.repository.DbColBoolean;
import ch.ehi.sqlgen.repository.DbColDate;
import ch.ehi.sqlgen.repository.DbColDateTime;
import ch.ehi.sqlgen.repository.DbColDecimal;
import ch.ehi.sqlgen.repository.DbColGeometry;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColJson;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColTime;
import ch.ehi.sqlgen.repository.DbColUuid;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColXml;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbIndex;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;

public class GeneratorPostgresql
extends GeneratorJdbc {
    private boolean createGeomIdx = false;
    private ArrayList<DbColumn> indexColumns = null;
    private DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private DateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss.SSS");

    @Override
    public void visitSchemaBegin(Settings config, DbSchema schema) throws IOException {
        super.visitSchemaBegin(config, schema);
        if ("True".equals(config.getValue("ch.ehi.sqlgen.createGeomIndex"))) {
            this.createGeomIdx = true;
        }
    }

    @Override
    public void visitColumn(DbTable dbTab, DbColumn column) throws IOException {
        String isNull;
        String type = "";
        String size = "";
        Object notSupported = null;
        boolean createColNow = true;
        if (column instanceof DbColBoolean) {
            type = "boolean";
        } else if (column instanceof DbColDateTime) {
            type = "timestamp";
        } else if (column instanceof DbColDate) {
            type = "date";
        } else if (column instanceof DbColTime) {
            type = "time";
        } else if (column instanceof DbColDecimal) {
            DbColDecimal col = (DbColDecimal)column;
            type = "decimal(" + Integer.toString(col.getSize()) + "," + Integer.toString(col.getPrecision()) + ")";
        } else if (column instanceof DbColGeometry) {
            DbColGeometry geo = (DbColGeometry)column;
            if (!geo.getSrsAuth().equals("EPSG")) {
                throw new IllegalArgumentException("unexpected SrsAuth <" + geo.getSrsAuth() + ">");
            }
            type = "geometry(" + GeneratorPostgresql.getPostgisType(geo.getType()) + (geo.getDimension() == 3 ? "Z" : "") + "," + geo.getSrsId() + ")";
        } else {
            int colsize;
            DbColNumber col;
            type = column instanceof DbColId ? "bigint" : (column instanceof DbColUuid ? "uuid" : (column instanceof DbColNumber ? ((col = (DbColNumber)column).getSize() > 10 || col.getMaxValue() != null && col.getMaxValue() > Integer.MAX_VALUE || col.getMinValue() != null && col.getMinValue() < Integer.MIN_VALUE ? "bigint" : "integer") : (column instanceof DbColVarchar ? ((colsize = ((DbColVarchar)column).getSize()) == -1 ? "text" : "varchar(" + Integer.toString(colsize) + ")") : (column instanceof DbColBlob ? "bytea" : (column instanceof DbColXml ? "xml" : (column instanceof DbColJson ? "jsonb" : "text"))))));
        }
        String array = "";
        if (column.getArraySize() != 0) {
            array = column.getArraySize() == -1 ? "ARRAY " : "ARRAY[" + column.getArraySize() + "] ";
        }
        String string = isNull = column.isNotNull() ? "NOT NULL" : "NULL";
        if (column.isPrimaryKey()) {
            isNull = "PRIMARY KEY";
        }
        String sep = " ";
        String defaultValue = "";
        if (column.getDefaultValue() != null) {
            defaultValue = sep + "DEFAULT " + column.getDefaultValue();
            sep = " ";
        }
        if (column.isIndex() || this.createGeomIdx && column instanceof DbColGeometry) {
            this.indexColumns.add(column);
        }
        if (createColNow) {
            String name = column.getName();
            this.out.write(this.getIndent() + this.colSep + name + " " + type + " " + array + isNull + defaultValue + this.newline());
            this.colSep = ",";
        }
    }

    @Override
    public void visit1TableBegin(DbTable tab) throws IOException {
        super.visit1TableBegin(tab);
        this.indexColumns = new ArrayList();
    }

    @Override
    public void visitTableEndColumn(DbTable tab) throws IOException {
        boolean tableExists = DbUtility.tableExists(this.conn, tab.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitIndex(DbIndex idx) throws IOException {
        if (idx.isUnique()) {
            StringWriter out = new StringWriter();
            DbTable tab = idx.getTable();
            String tableName = tab.getName().getQName();
            String constraintName = idx.getName();
            if (constraintName == null) {
                String[] colNames = new String[idx.sizeAttr()];
                int i = 0;
                Iterator attri = idx.iteratorAttr();
                while (attri.hasNext()) {
                    DbColumn attr = (DbColumn)attri.next();
                    colNames[i++] = attr.getName();
                }
                constraintName = this.createConstraintName(tab, "key", colNames);
            }
            out.write(this.getIndent() + "CREATE UNIQUE INDEX " + constraintName + " ON " + tableName + " (");
            String sep = "";
            Iterator attri = idx.iteratorAttr();
            while (attri.hasNext()) {
                DbColumn attr = (DbColumn)attri.next();
                if (attr instanceof DbColGeometry) {
                    if (((DbColGeometry)attr).getType() == 0) {
                        // empty if block
                    }
                    out.write(sep + "ST_AsBinary(" + attr.getName() + ")");
                } else {
                    out.write(sep + attr.getName());
                }
                sep = ",";
            }
            out.write(")" + this.newline());
            String stmt = out.toString();
            this.addCreateLine(new GeneratorJdbc.Stmt(stmt));
            out = null;
            if (this.conn != null && this.createdTables.contains(tab.getName())) {
                Statement dbstmt = null;
                try {
                    try {
                        dbstmt = this.conn.createStatement();
                        EhiLogger.traceBackendCmd((String)stmt);
                        dbstmt.executeUpdate(stmt);
                    }
                    finally {
                        dbstmt.close();
                    }
                }
                catch (SQLException ex) {
                    IOException iox = new IOException("failed to add UNIQUE to table " + tab.getName());
                    iox.initCause(ex);
                    throw iox;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit1TableEnd(DbTable tab) throws IOException {
        String sqlTabName = tab.getName().getName();
        if (tab.getName().getSchema() != null) {
            sqlTabName = tab.getName().getSchema() + "." + sqlTabName;
        }
        boolean tableExists = DbUtility.tableExists(this.conn, tab.getName());
        super.visit1TableEnd(tab);
        for (DbColumn idxcol : this.indexColumns) {
            String idxstmt = null;
            String idxName = this.createConstraintName(tab, "idx", idxcol.getName().toLowerCase());
            idxstmt = idxcol instanceof DbColGeometry ? "CREATE INDEX " + idxName + " ON " + sqlTabName.toLowerCase() + " USING GIST ( " + idxcol.getName().toLowerCase() + " )" : "CREATE INDEX " + idxName + " ON " + sqlTabName.toLowerCase() + " ( " + idxcol.getName().toLowerCase() + " )";
            this.addCreateLine(new GeneratorJdbc.Stmt(idxstmt));
            if (this.conn == null || tableExists) continue;
            Statement dbstmt = null;
            try {
                try {
                    dbstmt = this.conn.createStatement();
                    EhiLogger.traceBackendCmd((String)idxstmt);
                    dbstmt.execute(idxstmt);
                }
                finally {
                    dbstmt.close();
                }
            }
            catch (SQLException ex) {
                IOException iox = new IOException("failed to add index on column " + tab.getName() + "." + idxcol.getName());
                iox.initCause(ex);
                throw iox;
            }
        }
        this.indexColumns = null;
        String cmt = tab.getComment();
        if (cmt != null) {
            cmt = "COMMENT ON TABLE " + sqlTabName + " IS '" + GeneratorPostgresql.escapeString(cmt) + "'";
            this.addCreateLine(new GeneratorJdbc.Stmt(cmt));
            if (this.conn != null && !tableExists) {
                Statement dbstmt = null;
                try {
                    try {
                        dbstmt = this.conn.createStatement();
                        EhiLogger.traceBackendCmd((String)cmt);
                        dbstmt.execute(cmt);
                    }
                    finally {
                        dbstmt.close();
                    }
                }
                catch (SQLException ex) {
                    IOException iox = new IOException("failed to add comment to table " + tab.getName());
                    iox.initCause(ex);
                    throw iox;
                }
            }
        }
        Iterator<DbColumn> coli = tab.iteratorColumn();
        while (coli.hasNext()) {
            DbColumn col = coli.next();
            cmt = col.getComment();
            if (cmt == null) continue;
            cmt = "COMMENT ON COLUMN " + sqlTabName + "." + col.getName() + " IS '" + GeneratorPostgresql.escapeString(cmt) + "'";
            this.addCreateLine(new GeneratorJdbc.Stmt(cmt));
            if (this.conn == null || tableExists) continue;
            Statement dbstmt = null;
            try {
                try {
                    dbstmt = this.conn.createStatement();
                    EhiLogger.traceBackendCmd((String)cmt);
                    dbstmt.execute(cmt);
                }
                finally {
                    dbstmt.close();
                }
            }
            catch (SQLException ex) {
                IOException iox = new IOException("failed to add comment to table " + tab.getName());
                iox.initCause(ex);
                throw iox;
            }
        }
    }

    public static String escapeString(String cmt) {
        StringBuilder ret = new StringBuilder(cmt.length());
        for (int i = 0; i < cmt.length(); ++i) {
            char c = cmt.charAt(i);
            ret.append(c);
            if (c != '\'') continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static String getPostgisType(int type) {
        switch (type) {
            case 0: {
                return "POINT";
            }
            case 2: {
                return "LINESTRING";
            }
            case 3: {
                return "POLYGON";
            }
            case 4: {
                return "MULTIPOINT";
            }
            case 5: {
                return "MULTILINESTRING";
            }
            case 6: {
                return "MULTIPOLYGON";
            }
            case 7: {
                return "GEOMETRYCOLLECTION";
            }
            case 8: {
                return "CIRCULARSTRING";
            }
            case 9: {
                return "COMPOUNDCURVE";
            }
            case 10: {
                return "CURVEPOLYGON";
            }
            case 11: {
                return "MULTICURVE";
            }
            case 12: {
                return "MULTISURFACE";
            }
            case 15: {
                return "POLYHEDRALSURFACE";
            }
            case 16: {
                return "TIN";
            }
            case 17: {
                return "TRIANGLE";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void visitTableBeginConstraint(DbTable dbTab) throws IOException {
        String createstmt;
        super.visitTableBeginConstraint(dbTab);
        String sqlTabName = dbTab.getName().getQName();
        Iterator<DbColumn> dbColi = dbTab.iteratorColumn();
        while (dbColi.hasNext()) {
            DbColVarchar dbColTxt;
            String dropstmt;
            String action;
            DbColumn dbColNum;
            DbColumn dbCol = dbColi.next();
            if (dbCol.getReferencedTable() != null && dbCol.getArraySize() == 0) {
                String createstmt2 = null;
                String action2 = "";
                if (dbCol.getOnUpdateAction() != null) {
                    action2 = action2 + " ON UPDATE " + dbCol.getOnUpdateAction();
                }
                if (dbCol.getOnDeleteAction() != null) {
                    action2 = action2 + " ON DELETE " + dbCol.getOnDeleteAction();
                }
                String constraintName2 = this.createConstraintName(dbTab, "fkey", dbCol.getName());
                createstmt2 = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + constraintName2 + " FOREIGN KEY ( " + dbCol.getName() + " ) REFERENCES " + dbCol.getReferencedTable().getQName() + action2 + " DEFERRABLE INITIALLY DEFERRED";
                Object var8_9 = null;
                String string = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + constraintName2;
                this.addConstraint(dbTab, constraintName2, createstmt2, string);
            }
            if (dbCol instanceof DbColNumber && (((DbColNumber)dbCol).getMinValue() != null || ((DbColNumber)dbCol).getMaxValue() != null)) {
                if (dbCol.getArraySize() == 0) {
                    dbColNum = (DbColNumber)dbCol;
                    createstmt = null;
                    action = "";
                    if (((DbColNumber)dbColNum).getMinValue() != null || ((DbColNumber)dbColNum).getMaxValue() != null) {
                        action = ((DbColNumber)dbColNum).getMaxValue() == null ? ">=" + ((DbColNumber)dbColNum).getMinValue() : (((DbColNumber)dbColNum).getMinValue() == null ? "<=" + ((DbColNumber)dbColNum).getMaxValue() : "BETWEEN " + ((DbColNumber)dbColNum).getMinValue() + " AND " + ((DbColNumber)dbColNum).getMaxValue());
                    }
                    String string = this.createConstraintName(dbTab, "check", dbCol.getName());
                    createstmt = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + string + " CHECK( " + dbCol.getName() + " " + action + ")";
                    dropstmt = null;
                    dropstmt = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + string;
                    this.addConstraint(dbTab, string, createstmt, dropstmt);
                }
            } else if (dbCol instanceof DbColDecimal && (((DbColDecimal)dbCol).getMinValue() != null || ((DbColDecimal)dbCol).getMaxValue() != null)) {
                if (dbCol.getArraySize() == 0) {
                    dbColNum = (DbColDecimal)dbCol;
                    createstmt = null;
                    action = "";
                    if (((DbColDecimal)dbColNum).getMinValue() != null || ((DbColDecimal)dbColNum).getMaxValue() != null) {
                        action = ((DbColDecimal)dbColNum).getMaxValue() == null ? ">=" + ((DbColDecimal)dbColNum).getMinValue() : (((DbColDecimal)dbColNum).getMinValue() == null ? "<=" + ((DbColDecimal)dbColNum).getMaxValue() : "BETWEEN " + ((DbColDecimal)dbColNum).getMinValue() + " AND " + ((DbColDecimal)dbColNum).getMaxValue());
                    }
                    String string = this.createConstraintName(dbTab, "check", dbCol.getName());
                    createstmt = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + string + " CHECK( " + dbCol.getName() + " " + action + ")";
                    dropstmt = null;
                    dropstmt = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + string;
                    this.addConstraint(dbTab, string, createstmt, dropstmt);
                }
            } else if (dbCol instanceof DbColDate && (((DbColDate)dbCol).getMinValue() != null || ((DbColDate)dbCol).getMaxValue() != null)) {
                if (dbCol.getArraySize() == 0) {
                    dbColNum = (DbColDate)dbCol;
                    createstmt = null;
                    action = "";
                    if (((DbColDate)dbColNum).getMinValue() != null || ((DbColDate)dbColNum).getMaxValue() != null) {
                        action = ((DbColDate)dbColNum).getMaxValue() == null ? ">=" + this.toDateLiteral(((DbColDate)dbColNum).getMinValue()) : (((DbColDate)dbColNum).getMinValue() == null ? "<=" + this.toDateLiteral(((DbColDate)dbColNum).getMaxValue()) : "BETWEEN " + this.toDateLiteral(((DbColDate)dbColNum).getMinValue()) + " AND " + this.toDateLiteral(((DbColDate)dbColNum).getMaxValue()));
                    }
                    String string = this.createConstraintName(dbTab, "check", dbCol.getName());
                    createstmt = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + string + " CHECK( " + dbCol.getName() + " " + action + ")";
                    dropstmt = null;
                    dropstmt = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + string;
                    this.addConstraint(dbTab, string, createstmt, dropstmt);
                }
            } else if (dbCol instanceof DbColTime && (((DbColTime)dbCol).getMinValue() != null || ((DbColTime)dbCol).getMaxValue() != null)) {
                if (dbCol.getArraySize() == 0) {
                    dbColNum = (DbColTime)dbCol;
                    createstmt = null;
                    action = "";
                    if (((DbColTime)dbColNum).getMinValue() != null || ((DbColTime)dbColNum).getMaxValue() != null) {
                        action = ((DbColTime)dbColNum).getMaxValue() == null ? ">=" + this.toTimeLiteral(((DbColTime)dbColNum).getMinValue()) : (((DbColTime)dbColNum).getMinValue() == null ? "<=" + this.toTimeLiteral(((DbColTime)dbColNum).getMaxValue()) : "BETWEEN " + this.toTimeLiteral(((DbColTime)dbColNum).getMinValue()) + " AND " + this.toTimeLiteral(((DbColTime)dbColNum).getMaxValue()));
                    }
                    String string = this.createConstraintName(dbTab, "check", dbCol.getName());
                    createstmt = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + string + " CHECK( " + dbCol.getName() + " " + action + ")";
                    dropstmt = null;
                    dropstmt = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + string;
                    this.addConstraint(dbTab, string, createstmt, dropstmt);
                }
            } else if (dbCol instanceof DbColDateTime && (((DbColDateTime)dbCol).getMinValue() != null || ((DbColDateTime)dbCol).getMaxValue() != null) && dbCol.getArraySize() == 0) {
                dbColNum = (DbColDateTime)dbCol;
                createstmt = null;
                action = "";
                if (((DbColDateTime)dbColNum).getMinValue() != null || ((DbColDateTime)dbColNum).getMaxValue() != null) {
                    action = ((DbColDateTime)dbColNum).getMaxValue() == null ? ">=" + this.toDateTimeLiteral(((DbColDateTime)dbColNum).getMinValue()) : (((DbColDateTime)dbColNum).getMinValue() == null ? "<=" + this.toDateTimeLiteral(((DbColDateTime)dbColNum).getMaxValue()) : "BETWEEN " + this.toDateTimeLiteral(((DbColDateTime)dbColNum).getMinValue()) + " AND " + this.toDateTimeLiteral(((DbColDateTime)dbColNum).getMaxValue()));
                }
                String string = this.createConstraintName(dbTab, "check", dbCol.getName());
                createstmt = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + string + " CHECK( " + dbCol.getName() + " " + action + ")";
                dropstmt = null;
                dropstmt = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + string;
                this.addConstraint(dbTab, string, createstmt, dropstmt);
            }
            if (dbCol instanceof DbColVarchar && dbCol.getArraySize() == 0) {
                String sep;
                CharSequence action2;
                dbColTxt = (DbColVarchar)dbCol;
                if (dbColTxt.getValueRestriction() != null) {
                    action2 = new StringBuffer("IN (");
                    sep = "";
                    for (String restrictedValue : dbColTxt.getValueRestriction()) {
                        ((StringBuffer)action2).append(sep);
                        ((StringBuffer)action2).append("'");
                        ((StringBuffer)action2).append(GeneratorPostgresql.escapeString(restrictedValue));
                        ((StringBuffer)action2).append("'");
                        sep = ",";
                    }
                    ((StringBuffer)action2).append(")");
                    String string = this.createConstraintName(dbTab, "check", dbCol.getName());
                    String createstmt2 = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + string + " CHECK( " + dbCol.getName() + " " + ((StringBuffer)action2).toString() + ")";
                    String dropstmt2 = null;
                    dropstmt2 = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + string;
                    this.addConstraint(dbTab, string, createstmt2, dropstmt2);
                } else if ("NORMALIZED".equals(dbColTxt.getKind()) || dbColTxt.getMinLength() != null) {
                    action2 = "";
                    sep = "";
                    if ("NORMALIZED".equals(dbColTxt.getKind())) {
                        action2 = (String)action2 + sep + "position('\\n' IN " + dbCol.getName() + ")=0 AND position('\\r' IN " + dbCol.getName() + ")=0 AND position('\\t' IN " + dbCol.getName() + ")=0";
                        sep = " AND ";
                    }
                    if (dbColTxt.getMinLength() != null) {
                        action2 = (String)action2 + sep + "length(trim(" + dbCol.getName() + "))>=" + dbColTxt.getMinLength();
                        sep = " AND ";
                    }
                    String string = this.createConstraintName(dbTab, "check", dbCol.getName());
                    String createstmt3 = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + string + " CHECK( " + ((String)action2).toString() + ")";
                    String dropstmt3 = null;
                    dropstmt3 = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + string;
                    this.addConstraint(dbTab, string, createstmt3, dropstmt3);
                }
            }
            if (!(dbCol instanceof DbColVarchar) || ((DbColVarchar)dbCol).getValueRestriction() == null || dbCol.getArraySize() != 0) continue;
            dbColTxt = (DbColVarchar)dbCol;
        }
        Iterator<String> cnstrIt = dbTab.iteratorNativeConstraints();
        while (cnstrIt.hasNext()) {
            String constraintName = cnstrIt.next();
            String action = dbTab.getNativeConstraint(constraintName);
            createstmt = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + constraintName + " " + action;
            String dropstmt = null;
            dropstmt = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + constraintName;
            this.addConstraint(dbTab, constraintName, createstmt, dropstmt);
        }
    }

    private String toDateLiteral(Date val) {
        return "DATE '" + this.dateFormatter.format(val) + "'";
    }

    private String toTimeLiteral(Time val) {
        return "TIME '" + this.timeFormatter.format(val) + "'";
    }

    private String toDateTimeLiteral(Timestamp val) {
        return "TIMESTAMP '" + this.dateTimeFormatter.format(val) + "'";
    }
}

