/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Type;
import java.beans.PropertyVetoException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ReferenceType
extends Type {
    AbstractClassDef referred;
    private LinkedList<AbstractClassDef> restrictedTo = new LinkedList();
    private boolean external = false;

    public AbstractClassDef getReferred() {
        return this.referred;
    }

    public String toString() {
        return "<ReferenceType to " + this.referred + ">";
    }

    public void setReferred(AbstractClassDef referred) throws PropertyVetoException {
        AbstractClassDef oldValue = this.referred;
        AbstractClassDef newValue = referred;
        if (oldValue == newValue) {
            return;
        }
        this.fireVetoableChange("referred", oldValue, newValue);
        this.referred = newValue;
        this.firePropertyChange("referred", oldValue, newValue);
    }

    @Override
    void checkTypeExtension(Type wantToExtend) {
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        if (!(wantToExtend instanceof ReferenceType)) {
            throw new IllegalArgumentException(rsrc.getString("err_referenceType_ExtOther"));
        }
        ReferenceType general = (ReferenceType)wantToExtend;
        if (this.referred != null && general.referred != null && !this.referred.isExtending(general.referred)) {
            throw new IllegalArgumentException(ReferenceType.formatMessage("err_referenceType_nonExtending", this.referred.toString(), general.referred.toString()));
        }
    }

    public void addRestrictedTo(AbstractClassDef classOrAssociation) {
        this.restrictedTo.add(classOrAssociation);
        if (this.referred != PredefinedModel.getInstance().ANYCLASS && !classOrAssociation.isExtending(this.referred)) {
            throw new IllegalArgumentException(ReferenceType.formatMessage("err_referenceType_restriction", classOrAssociation.toString(), this.referred.toString()));
        }
    }

    public Iterator<AbstractClassDef> iteratorRestrictedTo() {
        return this.restrictedTo.iterator();
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public boolean isExternal() {
        return this.external;
    }

    @Override
    public ReferenceType clone() {
        ReferenceType cloned = (ReferenceType)super.clone();
        cloned.restrictedTo = (LinkedList)this.restrictedTo.clone();
        return cloned;
    }

    @Override
    protected void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) {
        super.checkTranslationOf(errs, name, baseName);
        ReferenceType baseElement = (ReferenceType)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (this.isExternal() != baseElement.isExternal()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), ReferenceType.formatMessage("err_diff_mismatchInExternal", name, baseName)));
        }
        Ili2cSemanticException err = null;
        err = ReferenceType.checkElementRef(this.getReferred(), baseElement.getReferred(), this.getSourceLine(), "err_diff_referencedClassMismatch");
        if (err != null) {
            errs.add(err);
        }
        Iterator<AbstractClassDef> depIt = this.iteratorRestrictedTo();
        Iterator<AbstractClassDef> baseDepIt = baseElement.iteratorRestrictedTo();
        while (true) {
            AbstractClassDef baseDep;
            if (!depIt.hasNext() || !baseDepIt.hasNext()) {
                if (depIt.hasNext() == baseDepIt.hasNext()) break;
                errs.add(new Ili2cSemanticException(this.getSourceLine(), ReferenceType.formatMessage("err_diff_referencedClassMismatch")));
                break;
            }
            AbstractClassDef dep = depIt.next();
            err = ReferenceType.checkElementRef(dep, baseDep = baseDepIt.next(), this.getSourceLine(), "err_diff_referencedClassMismatch");
            if (err == null) continue;
            errs.add(err);
        }
    }
}

