/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.csv;

import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.metamodel.DataModel;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.iom.IomObject;
import ch.interlis.iox.EndBasketEvent;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactoryCollection;
import ch.interlis.iox.IoxWriter;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox.StartTransferEvent;
import ch.interlis.iox_j.ObjectEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CsvWriter
implements IoxWriter {
    private TransferDescription td = null;
    private static final int START = 0;
    private static final int INSIDE_LINEFEED = 1;
    private static final int INSIDE_CARRIAGERETURN = 2;
    private static final int END_LINEFEED = 3;
    private static final int END_CARRIAGERETURN = 4;
    private static final char DEFAULT_VALUE_DELIMITER = '\"';
    private static final char DEFAULT_VALUE_SEPARATOR = ',';
    private static final char NEWLINE_CARRIAGERETURN = '\r';
    private static final char NEWLINE_LINEFEED = '\n';
    private BufferedWriter writer = null;
    private boolean doHeader = true;
    private Character currentValueDelimiter = Character.valueOf('\"');
    private char currentValueSeparator = (char)44;
    private boolean firstObj = true;
    private String[] headerAttrNames = null;

    public CsvWriter(File file) throws IoxException {
        this(file, null);
    }

    public CsvWriter(File file, Settings settings) throws IoxException {
        if (file != null) {
            String encoding = null;
            if (settings != null) {
                encoding = settings.getValue("ch.interlis.iom_j.csv.encoding");
            }
            if (encoding == null) {
                encoding = Charset.defaultCharset().name();
            }
            try {
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
            }
            catch (IOException e) {
                throw new IoxException("could not create file", (Throwable)e);
            }
        }
    }

    private Viewable findViewable(IomObject iomObj) throws IoxException {
        ArrayList<Viewable> foundIliClasses = null;
        Viewable ret = null;
        String tag = iomObj.getobjecttag();
        String[] elements = tag.split("\\.");
        String viewable = elements[elements.length - 1];
        if (this.td != null) {
            foundIliClasses = new ArrayList<Viewable>();
            List<HashMap<String, Viewable>> allModels = this.setupNameMapping();
            for (HashMap<String, Viewable> map : allModels) {
                ret = map.get(viewable);
                if (ret == null) continue;
                foundIliClasses.add(ret);
            }
            if (foundIliClasses.size() > 1) {
                throw new IoxException("several possible classes were found: " + ((Object)foundIliClasses).toString());
            }
            if (foundIliClasses.size() == 1) {
                return (Viewable)foundIliClasses.get(0);
            }
        }
        return null;
    }

    private String[] getAttributeNames(IomObject iomObj) {
        Object[] attrs = new String[iomObj.getattrcount()];
        int count = 0;
        for (int i = 0; i < iomObj.getattrcount(); ++i) {
            String attribute = iomObj.getattrname(i);
            attrs[count] = attribute;
            ++count;
        }
        Arrays.sort(attrs);
        return attrs;
    }

    private String[] getAttributeNames(Viewable viewable) {
        ArrayList<String> attrs = new ArrayList<String>();
        Iterator viewableIter = viewable.getAttributes();
        while (viewableIter.hasNext()) {
            Object attrObj = viewableIter.next();
            if (!(attrObj instanceof LocalAttribute)) continue;
            LocalAttribute localAttr = (LocalAttribute)attrObj;
            String iliAttrName = localAttr.getName();
            attrs.add(iliAttrName);
        }
        return attrs.toArray(new String[attrs.size()]);
    }

    private List<HashMap<String, Viewable>> setupNameMapping() {
        ArrayList<HashMap<String, Viewable>> allModels = new ArrayList<HashMap<String, Viewable>>();
        HashMap<String, Viewable> allClassesOfModel = null;
        Iterator tdIterator = this.td.iterator();
        while (tdIterator.hasNext()) {
            allClassesOfModel = new HashMap<String, Viewable>();
            Object modelObj = tdIterator.next();
            if (!(modelObj instanceof DataModel)) continue;
            DataModel model = (DataModel)modelObj;
            for (Object topicObj : model) {
                if (!(topicObj instanceof Topic)) continue;
                Topic topic = (Topic)topicObj;
                for (Object classObj : topic) {
                    if (!(classObj instanceof Viewable)) continue;
                    Viewable viewable = (Viewable)classObj;
                    allClassesOfModel.put(viewable.getName(), viewable);
                }
            }
            allModels.add(0, allClassesOfModel);
        }
        return allModels;
    }

    public void write(IoxEvent event) throws IoxException {
        if (!(event instanceof StartTransferEvent) && !(event instanceof StartBasketEvent)) {
            if (event instanceof ObjectEvent) {
                ObjectEvent obj = (ObjectEvent)event;
                IomObject iomObj = obj.getIomObject();
                if (this.firstObj) {
                    if (this.td != null) {
                        Viewable resultViewableHeader = this.findViewable(iomObj);
                        if (resultViewableHeader == null) {
                            throw new IoxException("class " + iomObj.getobjecttag() + " in model not found");
                        }
                        this.headerAttrNames = this.getAttributeNames(resultViewableHeader);
                    } else if (this.headerAttrNames == null) {
                        this.headerAttrNames = this.getAttributeNames(iomObj);
                    }
                    if (this.doHeader) {
                        try {
                            this.writeHeader(this.headerAttrNames);
                        }
                        catch (IOException e) {
                            throw new IoxException((Throwable)e);
                        }
                    }
                    this.firstObj = false;
                }
                String[] validAttrValues = this.getAttributeValues(this.headerAttrNames, iomObj);
                try {
                    this.writeRecord(validAttrValues);
                }
                catch (IOException e) {
                    throw new IoxException((Throwable)e);
                }
            }
            if (!(event instanceof EndBasketEvent)) {
                if (event instanceof EndTransferEvent) {
                    this.close();
                } else {
                    throw new IoxException("unknown event type " + event.getClass().getName());
                }
            }
        }
    }

    private String[] getAttributeValues(String[] attrNames, IomObject currentIomObject) {
        String[] attrValues = new String[attrNames.length];
        for (int i = 0; i < attrNames.length; ++i) {
            String attrValue;
            attrValues[i] = attrValue = currentIomObject.getattrvalue(attrNames[i]);
        }
        return attrValues;
    }

    private void writeHeader(String[] attrNames) throws IOException {
        boolean firstName = true;
        for (String name : attrNames) {
            if (!firstName) {
                this.writer.write(this.currentValueSeparator);
            }
            firstName = false;
            if (this.currentValueDelimiter != null) {
                this.writer.write(this.currentValueDelimiter.charValue());
            }
            this.writer.write(this.escapequotes(name));
            if (this.currentValueDelimiter == null) continue;
            this.writer.write(this.currentValueDelimiter.charValue());
        }
        this.writer.newLine();
    }

    private String escapequotes(String value) {
        if (value == null) {
            return "";
        }
        if (this.currentValueDelimiter == null) {
            return value;
        }
        String result = value;
        String quote = this.currentValueDelimiter.toString();
        if (result.contains(quote)) {
            result = result.replace(quote, quote + quote);
        }
        return result;
    }

    private void writeRecord(String[] attrValues) throws IOException, IoxException {
        boolean first = true;
        for (String value : attrValues) {
            if (!first) {
                this.writer.write(this.currentValueSeparator);
            }
            if (this.currentValueDelimiter != null) {
                this.writer.write(this.currentValueDelimiter.charValue());
            }
            String newValue = this.escapequotes(value);
            this.writeChars(newValue);
            if (this.currentValueDelimiter != null) {
                this.writer.write(this.currentValueDelimiter.charValue());
            }
            first = false;
        }
        this.writer.newLine();
    }

    private void writeChars(String attrValue) throws IOException {
        int state = 0;
        StringBuilder constructedValue = new StringBuilder();
        for (int i = 0; i < attrValue.length(); ++i) {
            char currentChar = attrValue.charAt(i);
            state = state == 1 ? (currentChar == '\r' ? 3 : 0) : (state == 2 ? (currentChar == '\n' ? 4 : 0) : 0);
            if (state == 0) {
                if (currentChar == '\n') {
                    this.writer.write(constructedValue.toString());
                    constructedValue.delete(0, constructedValue.length());
                    this.writer.newLine();
                    state = 1;
                    continue;
                }
                if (currentChar == '\r') {
                    this.writer.write(constructedValue.toString());
                    constructedValue.delete(0, constructedValue.length());
                    this.writer.newLine();
                    state = 2;
                    continue;
                }
                constructedValue.append(currentChar);
                continue;
            }
            state = 0;
        }
        this.writer.write(constructedValue.toString());
    }

    public void setModel(TransferDescription td) {
        if (this.headerAttrNames != null) {
            throw new IllegalStateException("attributes must not be set");
        }
        this.td = td;
    }

    public void setAttributes(String[] attr) {
        if (this.td != null) {
            throw new IllegalStateException("ili-model must not be set");
        }
        this.headerAttrNames = (String[])attr.clone();
    }

    public void close() throws IoxException {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new IoxException((Throwable)e);
            }
            this.writer = null;
        }
    }

    public void flush() throws IoxException {
    }

    public void setFactory(IoxFactoryCollection factory) throws IoxException {
    }

    public IoxFactoryCollection getFactory() throws IoxException {
        return null;
    }

    public IomObject createIomObject(String type, String oid) throws IoxException {
        return null;
    }

    public Character getValueDelimiter() {
        return this.currentValueDelimiter;
    }

    public void setValueDelimiter(Character delimiter) {
        this.currentValueDelimiter = delimiter;
    }

    public char getValueSeparator() {
        return this.currentValueSeparator;
    }

    public void setValueSeparator(char separator) {
        this.currentValueSeparator = separator;
    }

    public void setWriteHeader(boolean headerState) {
        this.doHeader = headerState;
    }
}

