/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.type;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.properties.ColumnSRID;

public class DimensionFromConstraint
extends DeterministicScalarFunction {
    private static final Pattern Z_CONSTRAINT_PATTERN = Pattern.compile("ST_COORDDIM\\s*\\(\\s*((([\"`][^\"`]+[\"`])|(\\w+)))\\s*\\)\\s*(((!|<|>)?=)|<>|>|<)\\s*(\\d+)", 2);

    public DimensionFromConstraint() {
        this.addProperty("remarks", "Check column constraint for Z constraint.");
        this.addProperty("name", "_DimensionFromConstraint");
    }

    public String getJavaStaticMethod() {
        return "dimensionFromConnection";
    }

    public static int dimensionFromConstraint(String constraint, String columnName) {
        String extractedColumnName;
        Matcher matcher = Z_CONSTRAINT_PATTERN.matcher(constraint);
        if (matcher.find() && (extractedColumnName = matcher.group(1).replace("\"", "").replace("`", "")).equalsIgnoreCase(columnName)) {
            int constraint_value = Integer.valueOf(matcher.group(8));
            String sign = matcher.group(5);
            if ("<>".equals(sign) || "!=".equals(sign)) {
                int n = constraint_value = constraint_value == 3 ? 2 : 3;
            }
            if ("<".equals(sign)) {
                constraint_value = 2;
            }
            if (">".equals(sign)) {
                constraint_value = constraint_value == 2 ? 3 : 2;
            }
            return constraint_value;
        }
        return 2;
    }

    public static int dimensionFromConnection(Connection connection, String catalogName, String schemaName, String tableName, String columnName, String constraint) {
        try {
            Statement st = connection.createStatement();
            constraint = constraint + ColumnSRID.fetchConstraint(connection, catalogName, schemaName, tableName);
            return DimensionFromConstraint.dimensionFromConstraint(constraint, columnName);
        }
        catch (SQLException ex) {
            return 2;
        }
    }
}

