/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.distance;

import java.util.Arrays;
import java.util.HashSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;

public class MaxDistanceOp {
    private final Geometry geomA;
    private final Geometry geomB;
    private MaxDistanceFilter maxDistanceFilter;
    private boolean sameGeom = false;

    public MaxDistanceOp(Geometry geomA, Geometry geomB) {
        this.geomA = geomA;
        this.geomB = geomB;
    }

    private void computeMaxDistance() {
        HashSet<Coordinate> coordinatesA = new HashSet<Coordinate>(Arrays.asList(this.geomA.convexHull().getCoordinates()));
        Geometry fullHull = this.geomA.getFactory().createGeometryCollection(new Geometry[]{this.geomA, this.geomB}).convexHull();
        this.maxDistanceFilter = new MaxDistanceFilter(coordinatesA);
        fullHull.apply((CoordinateFilter)this.maxDistanceFilter);
    }

    public Double getDistance() {
        if (this.geomA == null || this.geomB == null) {
            return null;
        }
        if (this.geomA.isEmpty() || this.geomB.isEmpty()) {
            return 0.0;
        }
        if (this.geomA.equals(this.geomB)) {
            this.sameGeom = true;
        }
        if (this.maxDistanceFilter == null) {
            this.computeMaxDistance();
        }
        return this.maxDistanceFilter.getDistance();
    }

    public Coordinate[] getCoordinatesDistance() {
        if (this.geomA == null || this.geomB == null) {
            return null;
        }
        if (this.geomA.isEmpty() || this.geomB.isEmpty()) {
            return null;
        }
        if (this.geomA.equals(this.geomB)) {
            this.sameGeom = true;
        }
        if (this.maxDistanceFilter == null) {
            this.computeMaxDistance();
        }
        return this.maxDistanceFilter.getCoordinatesDistance();
    }

    public class MaxDistanceFilter
    implements CoordinateFilter {
        private double distance = Double.MIN_VALUE;
        private final HashSet<Coordinate> coordsToExclude;
        private Coordinate startCoord = null;
        private Coordinate endCoord = null;

        public MaxDistanceFilter(HashSet<Coordinate> coordsToExclude) {
            this.coordsToExclude = coordsToExclude;
        }

        public void filter(Coordinate coord) {
            if (MaxDistanceOp.this.sameGeom) {
                this.coordsToExclude.remove(coord);
                this.updateDistance(coord);
            } else if (!this.coordsToExclude.contains(coord)) {
                this.updateDistance(coord);
            }
        }

        private void updateDistance(Coordinate coord) {
            for (Coordinate coordinate : this.coordsToExclude) {
                double currentDistance = coord.distance(coordinate);
                if (!(currentDistance > this.distance)) continue;
                this.distance = currentDistance;
                this.startCoord = coordinate;
                this.endCoord = coord;
            }
        }

        public double getDistance() {
            return this.distance;
        }

        public Coordinate[] getCoordinatesDistance() {
            if (this.startCoord == null || this.endCoord == null) {
                return null;
            }
            return new Coordinate[]{this.startCoord, this.endCoord};
        }
    }
}

