/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class ST_GeomFromText
extends DeterministicScalarFunction {
    public ST_GeomFromText() {
        this.addProperty("remarks", "Convert a Well Known Text geometry string into a geometry instance.");
    }

    public String getJavaStaticMethod() {
        return "toGeometry";
    }

    public static Geometry toGeometry(String wkt) throws SQLException {
        if (wkt == null) {
            return null;
        }
        WKTReader wktReader = new WKTReader();
        try {
            return wktReader.read(wkt);
        }
        catch (ParseException ex) {
            throw new SQLException("Cannot parse the WKT.", ex);
        }
    }

    public static Geometry toGeometry(String wkt, int srid) throws SQLException {
        if (wkt == null) {
            return null;
        }
        try {
            WKTReader wktReaderSRID = new WKTReader(new GeometryFactory(new PrecisionModel(), srid));
            return wktReaderSRID.read(wkt);
        }
        catch (ParseException ex) {
            throw new SQLException(ex);
        }
    }
}

