/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.osm;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.osm.OSMParser;
import org.h2gis.functions.io.osm.OSMTablesFactory;
import org.h2gis.utilities.JDBCUtilities;

public class OSMDriverFunction
implements DriverFunction {
    public static String DESCRIPTION = "OSM file (0.6)";
    public static String DESCRIPTION_GZ = "OSM Gzipped file (0.6)";
    public static String DESCRIPTION_BZ2 = "OSM Bzipped file (0.6)";

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getExportFormats() {
        return new String[0];
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("osm")) {
            return DESCRIPTION;
        }
        if (format.equalsIgnoreCase("gz")) {
            return DESCRIPTION_GZ;
        }
        if (format.equalsIgnoreCase("bz2")) {
            return DESCRIPTION_BZ2;
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return extension.equalsIgnoreCase("osm") || extension.equalsIgnoreCase("gz") || extension.equalsIgnoreCase("bz2");
    }

    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress, String options) throws SQLException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        this.importFile(connection, tableReference, fileName, progress, false);
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress, String options) throws SQLException, IOException {
        this.importFile(connection, tableReference, fileName, progress, false);
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress, boolean deleteTables) throws SQLException, IOException {
        if (fileName == null || !fileName.getName().endsWith(".osm") && !fileName.getName().endsWith("osm.gz") && !fileName.getName().endsWith("osm.bz2")) {
            throw new IOException(new IllegalArgumentException("This driver handle only .osm, .osm.gz and .osm.bz2 files"));
        }
        if (deleteTables) {
            OSMTablesFactory.dropOSMTables(connection, JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData()), tableReference);
        }
        OSMParser osmp = new OSMParser();
        osmp.read(connection, tableReference, fileName, progress);
    }

    public String[] getImportFormats() {
        return new String[]{"osm", "gz", "bz2"};
    }
}

