/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.kml;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.kml.KMLWriterDriver;

public class KMLDriverFunction
implements DriverFunction {
    public String[] getImportFormats() {
        return new String[0];
    }

    public String[] getExportFormats() {
        return new String[]{"kml", "kmz"};
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("kml")) {
            return "KML 2.2";
        }
        if (format.equalsIgnoreCase("kmz")) {
            return "KMZ 2.2";
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return extension.equalsIgnoreCase("kml") || extension.equalsIgnoreCase("kmz");
    }

    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        KMLWriterDriver kMLWriter = new KMLWriterDriver(connection, tableReference, fileName);
        kMLWriter.write(progress);
    }

    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress, String options) throws SQLException, IOException {
        this.exportTable(connection, tableReference, fileName, progress);
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress, String options) throws SQLException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress, boolean deleteTables) throws SQLException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }
}

