/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.geojson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.io.geojson.GJGeometryReader;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class ST_GeomFromGeoJSON
extends DeterministicScalarFunction {
    private static JsonFactory jsFactory;
    private static GJGeometryReader reader;

    public ST_GeomFromGeoJSON() {
        this.addProperty("remarks", "Convert a geojson representation of a geometry to a geometry object.");
    }

    public String getJavaStaticMethod() {
        return "geomFromGeoJSON";
    }

    public static Geometry geomFromGeoJSON(String geojson) throws IOException, SQLException {
        if (geojson == null) {
            return null;
        }
        if (jsFactory == null) {
            jsFactory = new JsonFactory();
            jsFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            jsFactory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            jsFactory.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
            reader = new GJGeometryReader(new GeometryFactory());
        }
        JsonParser jp = jsFactory.createParser(geojson);
        return reader.parseGeometry(jp);
    }
}

