/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Extendable;
import java.beans.PropertyVetoException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class ExtendableContainer<E extends Element>
extends Container<E>
implements Extendable {
    protected boolean _final = false;
    protected boolean _abstract = false;
    protected ExtendableContainer<E> extending = null;
    protected Set<ExtendableContainer<E>> extendedBy = Collections.newSetFromMap(new WeakHashMap());

    @Override
    public void setExtending(Element extending) throws PropertyVetoException {
        if (this.isAlias()) {
            ((ExtendableContainer)this.getReal()).setExtending(extending);
            return;
        }
        ExtendableContainer<E> oldValue = this.extending;
        ExtendableContainer newValue = (ExtendableContainer)extending;
        if (oldValue == newValue) {
            return;
        }
        if (newValue != null && newValue.isFinal()) {
            throw new IllegalArgumentException(ExtendableContainer.formatMessage("err_cantExtendFinal", newValue.toString()));
        }
        if (newValue != null && newValue.isExtending(this)) {
            throw new IllegalArgumentException(ExtendableContainer.formatMessage("err_cyclicExtension", this.toString(), newValue.toString()));
        }
        this.fireVetoableChange("extending", oldValue, newValue);
        if (oldValue != null) {
            oldValue.extendedBy.remove(this);
        }
        this.extending = newValue;
        if (newValue != null) {
            newValue.extendedBy.add(this);
        }
        this.firePropertyChange("extending", oldValue, newValue);
    }

    @Override
    public Element getExtending() {
        if (this.isAlias()) {
            return ((ExtendableContainer)this.getReal()).getExtending();
        }
        return this.extending;
    }

    public ExtendableContainer getRootExtending() {
        ExtendableContainer ret = (ExtendableContainer)this.getExtending();
        if (ret != null) {
            Element ret1;
            while ((ret1 = ret.getExtending()) != null) {
                ret = (ExtendableContainer)ret1;
            }
        }
        return ret;
    }

    @Override
    public Element getRealExtending() {
        if (this.isAlias()) {
            return ((ExtendableContainer)this.getReal()).getRealExtending();
        }
        Element ext = this.getExtending();
        return ext != null ? ext.getReal() : null;
    }

    @Override
    public boolean isExtending(Element extendee) {
        if (this.isAlias()) {
            return ((ExtendableContainer)this.getReal()).isExtending(extendee);
        }
        ExtendableContainer<E> parent = this;
        while (parent != null) {
            if (parent == extendee) {
                return true;
            }
            parent = parent.extending;
        }
        return false;
    }

    public boolean isAbstract() {
        if (this.isAlias()) {
            return ((ExtendableContainer)this.getReal()).isAbstract();
        }
        return this._abstract;
    }

    public void setAbstract(boolean abst) throws PropertyVetoException {
        if (this.isAlias()) {
            ((ExtendableContainer)this.getReal()).setAbstract(abst);
            return;
        }
        boolean oldValue = this._abstract;
        boolean newValue = abst;
        if (oldValue == newValue) {
            return;
        }
        if (newValue && this.isFinal()) {
            throw new IllegalArgumentException(rsrc.getString("err_abstractFinal"));
        }
        this.fireVetoableChange("abstract", oldValue, newValue);
        this._abstract = newValue;
        this.firePropertyChange("abstract", oldValue, newValue);
    }

    public boolean isFinal() {
        if (this.isAlias()) {
            return ((ExtendableContainer)this.getReal()).isFinal();
        }
        return this._final;
    }

    public void setFinal(boolean fin) throws PropertyVetoException {
        if (this.isAlias()) {
            ((ExtendableContainer)this.getReal()).setFinal(fin);
            return;
        }
        boolean oldValue = this._final;
        boolean newValue = fin;
        if (oldValue == newValue) {
            return;
        }
        if (newValue && this.isAbstract()) {
            throw new IllegalArgumentException(rsrc.getString("err_abstractFinal"));
        }
        if (newValue && !this.extendedBy.isEmpty()) {
            throw new IllegalArgumentException(ExtendableContainer.formatMessage("err_cantMakeExtendedFinal", this.toString(), this.extendedBy.iterator().next().toString()));
        }
        this.fireVetoableChange("final", oldValue, newValue);
        this._final = newValue;
        this.firePropertyChange("final", oldValue, newValue);
    }

    @Override
    public boolean isDependentOn(Element other) {
        if (this.isAlias()) {
            return ((ExtendableContainer)this.getReal()).isDependentOn(other);
        }
        return other instanceof Extendable && this.isExtending(other);
    }

    @Override
    public Element getElement(Class klass, String name) {
        if (this.isAlias()) {
            return ((ExtendableContainer)this.getReal()).getElement(klass, name);
        }
        Element elt = super.getElement(klass, name);
        if (elt != null) {
            return elt;
        }
        if (this.extending != null) {
            return this.extending.getElement(klass, name);
        }
        return null;
    }

    @Override
    public Set<ExtendableContainer<E>> getExtensions() {
        if (this.isAlias()) {
            return ((ExtendableContainer)this.getReal()).getExtensions();
        }
        HashSet<ExtendableContainer<E>> result = new HashSet<ExtendableContainer<E>>();
        this.getExtensions_recursiveHelper(result);
        return result;
    }

    public Set<ExtendableContainer<E>> getDirectExtensions() {
        return new HashSet<ExtendableContainer<E>>(this.extendedBy);
    }

    private final void getExtensions_recursiveHelper(Set<ExtendableContainer<E>> s) {
        s.add(this);
        Iterator<ExtendableContainer<E>> iter = this.extendedBy.iterator();
        while (iter.hasNext()) {
            super.getExtensions_recursiveHelper(s);
        }
    }

    @Override
    public boolean checkStructuralEquivalence(Element with) {
        if (this.isAlias()) {
            return ((ExtendableContainer)this.getReal()).checkStructuralEquivalence(with);
        }
        if (!super.checkStructuralEquivalence(with)) {
            return false;
        }
        boolean fine = true;
        if (this.isAbstract() != ((ExtendableContainer)with).isAbstract()) {
            EhiLogger.logError((String)ExtendableContainer.formatMessage("err_diff_mismatchInAbstractness", this.toString(), with.toString()));
            fine = false;
        }
        if (this.isFinal() != ((ExtendableContainer)with).isFinal()) {
            EhiLogger.logError((String)ExtendableContainer.formatMessage("err_diff_mismatchInFinality", this.toString(), with.toString()));
            fine = false;
        }
        return fine;
    }
}

