/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.mapping;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.base.Ili2db;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.base.StatementExecutionHelper;
import ch.ehi.ili2db.fromili.CustomMapping;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbTableName;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Viewable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class TrafoConfig {
    HashMap<String, HashMap<String, String>> config = null;
    private Integer batchSize = null;

    public TrafoConfig() {
    }

    public TrafoConfig(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void readTrafoConfig(Connection conn, String schema, CustomMapping customMapping) throws Ili2dbException {
        this.config = TrafoConfig.read(conn, schema, customMapping);
    }

    private static HashMap<String, HashMap<String, String>> read(Connection conn, String schema, CustomMapping customMapping) throws Ili2dbException {
        HashMap<String, HashMap<String, String>> settings = new HashMap<String, HashMap<String, String>>();
        String sqlName = "T_ILI2DB_TRAFO";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        if (conn != null && customMapping.tableExists(conn, new DbTableName(schema, "T_ILI2DB_TRAFO"))) {
            try {
                String insStmt = "SELECT iliname,tag,setting FROM " + sqlName;
                EhiLogger.traceBackendCmd((String)insStmt);
                PreparedStatement insPrepStmt = conn.prepareStatement(insStmt);
                ResultSet rs = null;
                try {
                    rs = insPrepStmt.executeQuery();
                    while (rs.next()) {
                        int valIdx = 1;
                        String iliname = rs.getString(valIdx++);
                        String tag = rs.getString(valIdx++);
                        String value = rs.getString(valIdx++);
                        TrafoConfig.setSetting(settings, iliname, tag, value);
                    }
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to read " + sqlName, ex);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (insPrepStmt != null) {
                        insPrepStmt.close();
                        insPrepStmt = null;
                    }
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to read " + sqlName, ex);
            }
        }
        return settings;
    }

    public void updateTrafoConfig(GeneratorJdbc gen, Connection conn, String schema, CustomMapping customMapping) throws Ili2dbException {
        String sqlName = "T_ILI2DB_TRAFO";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        if (conn != null) {
            HashMap<String, HashMap<String, String>> existingEntries = TrafoConfig.read(conn, schema, customMapping);
            StatementExecutionHelper seHelper = new StatementExecutionHelper(this.batchSize);
            try {
                String value;
                HashMap<String, String> values;
                String updStmt = "UPDATE " + sqlName + " SET " + "setting" + "=? WHERE " + "iliname" + "=? AND " + "tag" + "=?";
                EhiLogger.traceBackendCmd((String)updStmt);
                try (PreparedStatement updPrepStmt = conn.prepareStatement(updStmt);){
                    for (String iliname : this.config.keySet()) {
                        values = this.config.get(iliname);
                        for (String tag : values.keySet()) {
                            if (!TrafoConfig.containsSetting(existingEntries, iliname, tag)) continue;
                            value = values.get(tag);
                            updPrepStmt.clearParameters();
                            updPrepStmt.setString(1, value);
                            updPrepStmt.setString(2, iliname);
                            updPrepStmt.setString(3, tag);
                            seHelper.write(updPrepStmt);
                        }
                        seHelper.flush(updPrepStmt);
                    }
                }
                String insStmt = "INSERT INTO " + sqlName + " (" + "iliname" + "," + "tag" + "," + "setting" + ") VALUES (?,?,?)";
                EhiLogger.traceBackendCmd((String)insStmt);
                try (PreparedStatement insPrepStmt = conn.prepareStatement(insStmt);){
                    for (String iliname : this.config.keySet()) {
                        values = this.config.get(iliname);
                        for (String tag : values.keySet()) {
                            if (TrafoConfig.containsSetting(existingEntries, iliname, tag)) continue;
                            value = values.get(tag);
                            insPrepStmt.clearParameters();
                            insPrepStmt.setString(1, iliname);
                            insPrepStmt.setString(2, tag);
                            insPrepStmt.setString(3, value);
                            insPrepStmt.executeUpdate();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to update trafo-table " + sqlName, ex);
            }
        }
        if (gen != null) {
            for (String iliname : this.config.keySet()) {
                HashMap<String, String> values = this.config.get(iliname);
                for (String tag : values.keySet()) {
                    String value = values.get(tag);
                    String insStmt = "INSERT INTO " + sqlName + " (" + "iliname" + "," + "tag" + "," + "setting" + ") VALUES (" + Ili2db.quoteSqlStringValue(iliname) + "," + Ili2db.quoteSqlStringValue(tag) + "," + Ili2db.quoteSqlStringValue(value) + ")";
                    GeneratorJdbc generatorJdbc = gen;
                    generatorJdbc.getClass();
                    gen.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc, insStmt));
                }
            }
        }
    }

    private static boolean containsSetting(HashMap<String, HashMap<String, String>> settings, String iliname, String tag) {
        HashMap<String, String> values = null;
        if (!settings.containsKey(iliname)) {
            return false;
        }
        values = settings.get(iliname);
        return values.containsKey(tag);
    }

    private static String getSetting(HashMap<String, HashMap<String, String>> settings, String iliname, String tag) {
        HashMap<String, String> values = null;
        if (!settings.containsKey(iliname)) {
            return null;
        }
        values = settings.get(iliname);
        return values.get(tag);
    }

    private static void setSetting(HashMap<String, HashMap<String, String>> settings, String iliname, String tag, String value) {
        HashMap<Object, Object> values = null;
        if (settings.containsKey(iliname)) {
            values = settings.get(iliname);
        } else {
            values = new HashMap();
            settings.put(iliname, values);
        }
        values.put(tag, value);
    }

    private static String getIliQname(AttributeDef attr) {
        return attr.getContainer().getScopedName(null) + "." + attr.getName();
    }

    public String getAttrConfig(AttributeDef attr, String tag) {
        String iliname = TrafoConfig.getIliQname(attr);
        return TrafoConfig.getSetting(this.config, iliname, tag);
    }

    public String getAttrConfig(Viewable iliclass, AttributeDef attr, String tag) {
        String iliname = TrafoConfig.getIliQname(attr) + "(" + iliclass.getScopedName() + ")";
        String setting = TrafoConfig.getSetting(this.config, iliname, tag);
        if (setting == null) {
            setting = this.getAttrConfig(attr, tag);
        }
        return setting;
    }

    public String getAttrConfig(Viewable iliclass, AttributeDef attr, Integer epsgCode, String tag) {
        String iliname = null;
        iliname = epsgCode != null ? TrafoConfig.getIliQname(attr) + ":" + epsgCode + "(" + iliclass.getScopedName() + ")" : TrafoConfig.getIliQname(attr) + "(" + iliclass.getScopedName() + ")";
        String setting = TrafoConfig.getSetting(this.config, iliname, tag);
        return setting;
    }

    public String getViewableConfig(Viewable aclass, String tag) {
        String iliname = aclass.getScopedName(null);
        return TrafoConfig.getSetting(this.config, iliname, tag);
    }

    public void setAttrConfig(AttributeDef attr, String tag, String value) {
        String iliname = TrafoConfig.getIliQname(attr);
        TrafoConfig.setSetting(this.config, iliname, tag, value);
    }

    public void setAttrConfig(Viewable iliclass, AttributeDef attr, Integer epsgCode, String tag, String value) {
        String epsgCodeTxt = "";
        String subtype = "";
        if (epsgCode != null) {
            epsgCodeTxt = ":" + epsgCode;
            subtype = "(" + iliclass.getScopedName() + ")";
        } else if (!iliclass.equals(attr.getContainer())) {
            subtype = "(" + iliclass.getScopedName() + ")";
        }
        String iliname = TrafoConfig.getIliQname(attr) + epsgCodeTxt + subtype;
        TrafoConfig.setSetting(this.config, iliname, tag, value);
    }

    public void setViewableConfig(Viewable aclass, String tag, String value) {
        String iliname = aclass.getScopedName(null);
        TrafoConfig.setSetting(this.config, iliname, tag, value);
    }
}

