/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.converter;

import ch.ehi.basics.settings.Settings;
import ch.ehi.ili2db.converter.ConverterException;
import ch.ehi.ili2db.converter.SqlColumnConverter;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.iom.IomObject;
import ch.interlis.iox_j.jts.Iox2jts;
import ch.interlis.iox_j.jts.Iox2jtsException;
import ch.interlis.iox_j.jts.Jts2iox;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;

public abstract class AbstractWKTColumnConverter
implements SqlColumnConverter {
    @Override
    public void setCoordNull(PreparedStatement stmt, int parameterIndex) throws SQLException {
        stmt.setNull(parameterIndex, 2005);
    }

    @Override
    public void setDecimalNull(PreparedStatement stmt, int parameterIndex) throws SQLException {
        stmt.setNull(parameterIndex, 3);
    }

    @Override
    public void setUuidNull(PreparedStatement stmt, int parameterIndex) throws SQLException {
        stmt.setNull(parameterIndex, 12);
    }

    @Override
    public void setBoolean(PreparedStatement stmt, int parameterIndex, boolean value) throws SQLException {
        stmt.setBoolean(parameterIndex, value);
    }

    @Override
    public void setTimestamp(PreparedStatement stmt, int parameterIndex, Timestamp value) throws SQLException {
        stmt.setTimestamp(parameterIndex, value);
    }

    @Override
    public void setDate(PreparedStatement stmt, int parameterIndex, Date value) throws SQLException {
        stmt.setDate(parameterIndex, value);
    }

    @Override
    public void setTime(PreparedStatement stmt, int parameterIndex, Time value) throws SQLException {
        stmt.setTime(parameterIndex, value);
    }

    @Override
    public void setPolylineNull(PreparedStatement stmt, int parameterIndex) throws SQLException {
        stmt.setNull(parameterIndex, 2005);
    }

    @Override
    public void setSurfaceNull(PreparedStatement stmt, int parameterIndex) throws SQLException {
        stmt.setNull(parameterIndex, 2005);
    }

    @Override
    public String getInsertValueWrapperCoord(String wkfValue, int srid) {
        return "GeomFromWKT(" + wkfValue + (srid == -1 ? "" : "," + srid) + ")";
    }

    @Override
    public String getInsertValueWrapperMultiCoord(String wkfValue, int srid) {
        return "GeomFromWKT(" + wkfValue + (srid == -1 ? "" : "," + srid) + ")";
    }

    @Override
    public String getInsertValueWrapperPolyline(String wkfValue, int srid) {
        return "GeomFromWKT(" + wkfValue + (srid == -1 ? "" : "," + srid) + ")";
    }

    @Override
    public String getInsertValueWrapperMultiPolyline(String wkfValue, int srid) {
        return "GeomFromWKT(" + wkfValue + (srid == -1 ? "" : "," + srid) + ")";
    }

    @Override
    public String getInsertValueWrapperSurface(String wkfValue, int srid) {
        return "GeomFromWKT(" + wkfValue + (srid == -1 ? "" : "," + srid) + ")";
    }

    @Override
    public String getInsertValueWrapperMultiSurface(String wkfValue, int srid) {
        return "GeomFromWKT(" + wkfValue + (srid == -1 ? "" : "," + srid) + ")";
    }

    @Override
    public String getSelectValueWrapperDate(String sqlColName) {
        return sqlColName;
    }

    @Override
    public String getSelectValueWrapperTime(String sqlColName) {
        return sqlColName;
    }

    @Override
    public String getSelectValueWrapperDateTime(String sqlColName) {
        return sqlColName;
    }

    @Override
    public String getSelectValueWrapperCoord(String dbNativeValue) {
        return "AsText(" + dbNativeValue + ")";
    }

    @Override
    public String getSelectValueWrapperMultiCoord(String dbNativeValue) {
        return "AsText(" + dbNativeValue + ")";
    }

    @Override
    public String getSelectValueWrapperPolyline(String dbNativeValue) {
        return "AsText(" + dbNativeValue + ")";
    }

    @Override
    public String getSelectValueWrapperMultiPolyline(String dbNativeValue) {
        return "AsText(" + dbNativeValue + ")";
    }

    @Override
    public String getSelectValueWrapperSurface(String dbNativeValue) {
        return "AsText(" + dbNativeValue + ")";
    }

    @Override
    public String getSelectValueWrapperMultiSurface(String dbNativeValue) {
        return "AsText(" + dbNativeValue + ")";
    }

    @Override
    public Object fromIomUuid(String value) throws SQLException, ConverterException {
        return value;
    }

    @Override
    public Object fromIomCoord(IomObject value, int srid, boolean is3D) throws SQLException, ConverterException {
        if (value != null) {
            Point geom;
            try {
                geom = new GeometryFactory().createPoint(Iox2jts.coord2JTS((IomObject)value));
            }
            catch (Iox2jtsException ex) {
                throw new ConverterException(ex);
            }
            String bv = new WKTWriter(is3D ? 3 : 2).write((Geometry)geom);
            return bv;
        }
        return null;
    }

    @Override
    public Object fromIomMultiCoord(IomObject value, int srid, boolean is3D) throws SQLException, ConverterException {
        if (value != null) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    @Override
    public Object fromIomPolyline(IomObject value, int srid, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            Polygon geom;
            try {
                geom = Iox2jts.surface2JTS((IomObject)value, (double)p);
            }
            catch (Iox2jtsException ex) {
                throw new ConverterException(ex);
            }
            String bv = new WKTWriter(is3D ? 3 : 2).write((Geometry)geom);
            return bv;
        }
        return null;
    }

    @Override
    public Object fromIomMultiPolyline(IomObject value, int srid, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    @Override
    public Object fromIomSurface(IomObject value, int srid, boolean hasLineAttr, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            Polygon geom;
            try {
                geom = Iox2jts.surface2JTS((IomObject)value, (double)p);
            }
            catch (Iox2jtsException ex) {
                throw new ConverterException(ex);
            }
            String bv = new WKTWriter(is3D ? 3 : 2).write((Geometry)geom);
            return bv;
        }
        return null;
    }

    @Override
    public Object fromIomMultiSurface(IomObject value, int srid, boolean hasLineAttr, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            throw new ConverterException("MultiSurface not supported");
        }
        return null;
    }

    @Override
    public IomObject toIomCoord(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        Geometry geom;
        String bv = (String)geomobj;
        try {
            geom = new WKTReader().read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException(e);
        }
        return Jts2iox.JTS2coord((Coordinate)geom.getCoordinate());
    }

    @Override
    public IomObject toIomMultiCoord(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IomObject toIomSurface(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        Geometry geom;
        String bv = (String)geomobj;
        try {
            geom = new WKTReader().read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException(e);
        }
        return Jts2iox.JTS2surface((Polygon)((Polygon)geom));
    }

    @Override
    public IomObject toIomMultiSurface(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        Geometry geom;
        String bv = (String)geomobj;
        try {
            geom = new WKTReader().read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException(e);
        }
        return Jts2iox.JTS2surface((Polygon)((Polygon)geom));
    }

    @Override
    public IomObject toIomPolyline(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        Geometry geom;
        String bv = (String)geomobj;
        try {
            geom = new WKTReader().read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException(e);
        }
        return Jts2iox.JTS2polyline((LineString)((LineString)geom));
    }

    @Override
    public IomObject toIomMultiPolyline(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer getSrsid(String crsAuthority, String crsCode, Connection conn) throws ConverterException {
        int srsid;
        Statement stmt = null;
        ResultSet ret = null;
        try {
            stmt = conn.createStatement();
            ret = stmt.executeQuery("SELECT srid FROM SPATIAL_REF_SYS WHERE AUTH_NAME='" + crsAuthority + "' AND AUTH_SRID=" + crsCode);
            if (!ret.next()) {
                Integer n = null;
                return n;
            }
            srsid = ret.getInt("srid");
        }
        catch (SQLException ex) {
            throw new ConverterException("failed to query srsid from database", ex);
        }
        finally {
            if (ret != null) {
                try {
                    ret.close();
                }
                catch (SQLException e) {
                    throw new ConverterException("failed to close rs", e);
                }
                ret = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    throw new ConverterException("failed to close stmt", e);
                }
                stmt = null;
            }
        }
        return srsid;
    }

    @Override
    public void setup(Connection conn, Settings config) {
    }

    @Override
    public void setBlobNull(PreparedStatement stmt, int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setXmlNull(PreparedStatement stmt, int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fromIomBlob(String uuid) throws SQLException, ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fromIomXml(String uuid) throws SQLException, ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toIomXml(Object obj) throws SQLException, ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toIomBlob(Object obj) throws SQLException, ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSelectValueWrapperArray(String makeColumnRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getInsertValueWrapperArray(String sqlColName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setArrayNull(PreparedStatement ps, int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fromIomArray(AttributeDef iliEleAttr, String[] iomValues, Class<? extends DbColumn> dbColHint) throws SQLException, ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] toIomArray(AttributeDef iliEleAttr, Object sqlArray, Class<? extends DbColumn> dbColHint) throws SQLException, ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSelectValueWrapperJson(String makeColumnRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getInsertValueWrapperJson(String sqlColName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setJsonNull(PreparedStatement ps, int parameterIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fromIomStructureToJson(AttributeDef iliEleAttr, IomObject[] iomValues) throws SQLException, ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fromIomStructureToJsonArray(AttributeDef iliEleAttr, IomObject[] iomValues) throws SQLException, ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IomObject[] toIomStructureFromJson(AttributeDef iliEleAttr, Object sqlArray) throws SQLException, ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fromIomValueArrayToJson(AttributeDef iliEleAttr, String[] iomValues, boolean isEnumInt) throws SQLException, ConverterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] toIomValueArrayFromJson(AttributeDef iliEleAttr, Object sqlArray, boolean isEnumInt) throws SQLException, ConverterException {
        throw new UnsupportedOperationException();
    }
}

