/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.jts_utils;

import java.io.IOException;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.ByteOrderDataInStream;
import org.locationtech.jts.io.InStream;

public class GeometryMetaData {
    public final boolean hasSRID;
    public final boolean hasZ;
    public final int geometryType;
    public final int dimension;
    public final int SRID;

    private GeometryMetaData(int dimension, boolean hasSRID, boolean hasZ, int geometryType, int SRID) {
        this.dimension = dimension;
        this.hasSRID = hasSRID;
        this.hasZ = hasZ;
        this.geometryType = geometryType;
        this.SRID = SRID;
    }

    public static GeometryMetaData getMetaDataFromWKB(byte[] bytes) throws IOException {
        ByteOrderDataInStream dis = new ByteOrderDataInStream();
        dis.setInStream((InStream)new ByteArrayInStream(bytes));
        byte byteOrderWKB = dis.readByte();
        int byteOrder = byteOrderWKB == 1 ? 2 : 1;
        dis.setOrder(byteOrder);
        int typeInt = dis.readInt();
        int geometryType = typeInt & 0xFF;
        boolean hasZ = (typeInt & Integer.MIN_VALUE) != 0;
        int inputDimension = hasZ ? 3 : 2;
        boolean hasSRID = (typeInt & 0x20000000) != 0;
        int SRID = 0;
        if (hasSRID) {
            SRID = dis.readInt();
        }
        return new GeometryMetaData(inputDimension, hasSRID, hasZ, geometryType, SRID);
    }
}

