/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.properties;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public class ST_EndPoint
extends DeterministicScalarFunction {
    public ST_EndPoint() {
        this.addProperty("remarks", "Returns the last coordinate of a Geometry as a POINT, given that the Geometry is a LINESTRING or a MULTILINESTRING containing only one LINESTRING. Returns NULL for all other Geometries. ");
    }

    public String getJavaStaticMethod() {
        return "getEndPoint";
    }

    public static Geometry getEndPoint(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof MultiLineString) {
            if (geometry.getNumGeometries() == 1) {
                return ((LineString)geometry.getGeometryN(0)).getEndPoint();
            }
        } else if (geometry instanceof LineString) {
            return ((LineString)geometry).getEndPoint();
        }
        return null;
    }
}

