/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Polygon;

public class ST_ToMultiSegments
extends DeterministicScalarFunction {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    public ST_ToMultiSegments() {
        this.addProperty("remarks", "Converts a geometry into a set of distinct segments stored in a MultiLineString.");
    }

    public String getJavaStaticMethod() {
        return "createSegments";
    }

    public static MultiLineString createSegments(Geometry geom) throws SQLException {
        if (geom != null) {
            if (geom.getDimension() > 0) {
                LinkedList<LineString> result = new LinkedList<LineString>();
                ST_ToMultiSegments.createSegments(geom, result);
                return GEOMETRY_FACTORY.createMultiLineString(result.toArray(new LineString[0]));
            }
            return GEOMETRY_FACTORY.createMultiLineString(null);
        }
        return null;
    }

    private static void createSegments(Geometry geom, List<LineString> result) throws SQLException {
        if (geom instanceof LineString) {
            ST_ToMultiSegments.createSegments((LineString)geom, result);
        } else if (geom instanceof Polygon) {
            ST_ToMultiSegments.createSegments((Polygon)geom, result);
        } else if (geom instanceof GeometryCollection) {
            ST_ToMultiSegments.createSegments((GeometryCollection)geom, result);
        }
    }

    public static void createSegments(LineString geom, List<LineString> result) throws SQLException {
        Coordinate[] coords = CoordinateArrays.removeRepeatedPoints((Coordinate[])geom.getCoordinates());
        for (int j = 0; j < coords.length - 1; ++j) {
            LineString lineString = GEOMETRY_FACTORY.createLineString(new Coordinate[]{coords[j], coords[j + 1]});
            result.add(lineString);
        }
    }

    private static void createSegments(Polygon polygon, List<LineString> result) throws SQLException {
        ST_ToMultiSegments.createSegments(polygon.getExteriorRing(), result);
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            ST_ToMultiSegments.createSegments(polygon.getInteriorRingN(i), result);
        }
    }

    private static void createSegments(GeometryCollection geometryCollection, List<LineString> result) throws SQLException {
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            ST_ToMultiSegments.createSegments(geometryCollection.getGeometryN(i), result);
        }
    }
}

