/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import java.io.IOException;
import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.utilities.jts_utils.GeometryMetaData;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

public class ST_LineFromWKB
extends DeterministicScalarFunction {
    public ST_LineFromWKB() {
        this.addProperty("remarks", "Convert Well Known Binary into a LINESTRING.\n If an SRID is not specified, it defaults to 0.");
    }

    public String getJavaStaticMethod() {
        return "toLineString";
    }

    public static Geometry toLineString(byte[] bytes) throws SQLException, IOException {
        return ST_LineFromWKB.toLineString(bytes, 0);
    }

    public static Geometry toLineString(byte[] bytes, int srid) throws SQLException, IOException {
        if (bytes == null) {
            return null;
        }
        WKBReader wkbReader = new WKBReader();
        try {
            if (GeometryMetaData.getMetaDataFromWKB((byte[])bytes).geometryType != 2) {
                throw new SQLException("Provided WKB is not a LINESTRING.");
            }
            Geometry geometry = wkbReader.read(bytes);
            geometry.setSRID(srid);
            return geometry;
        }
        catch (ParseException ex) {
            throw new SQLException("ParseException while evaluating ST_LineFromWKB", ex);
        }
    }
}

