/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.buffer;

import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueString;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;

public class ST_Buffer
extends DeterministicScalarFunction {
    public ST_Buffer() {
        this.addProperty("remarks", "Compute a buffer around a Geometry.\nThe optional third parameter can either specify number of segments used\n to approximate a quarter circle (integer case, defaults to 8)\n or a list of blank-separated key=value pairs (string case) to manage buffer style parameters :\n'quad_segs=8' endcap=round|flat|square' 'join=round|mitre|bevel' 'mitre_limit=5'");
    }

    public String getJavaStaticMethod() {
        return "buffer";
    }

    public static Geometry buffer(Geometry geom, Double distance) {
        if (geom == null || distance == null) {
            return null;
        }
        return geom.buffer(distance.doubleValue());
    }

    public static Geometry buffer(Geometry geom, Double distance, Value value) throws IllegalArgumentException {
        if (geom == null) {
            return null;
        }
        if (value instanceof ValueString) {
            String[] buffParemeters = value.getString().split("\\s+");
            BufferParameters bufferParameters = new BufferParameters();
            for (String params : buffParemeters) {
                String param;
                String[] keyValue = params.split("=");
                if (keyValue[0].equalsIgnoreCase("endcap")) {
                    param = keyValue[1];
                    if (param.equalsIgnoreCase("round")) {
                        bufferParameters.setEndCapStyle(1);
                        continue;
                    }
                    if (param.equalsIgnoreCase("flat") || param.equalsIgnoreCase("butt")) {
                        bufferParameters.setEndCapStyle(2);
                        continue;
                    }
                    if (param.equalsIgnoreCase("square")) {
                        bufferParameters.setEndCapStyle(3);
                        continue;
                    }
                    throw new IllegalArgumentException("Supported join values are round, flat, butt or square.");
                }
                if (keyValue[0].equalsIgnoreCase("join")) {
                    param = keyValue[1];
                    if (param.equalsIgnoreCase("bevel")) {
                        bufferParameters.setJoinStyle(3);
                        continue;
                    }
                    if (param.equalsIgnoreCase("mitre") || param.equalsIgnoreCase("miter")) {
                        bufferParameters.setJoinStyle(2);
                        continue;
                    }
                    if (param.equalsIgnoreCase("round")) {
                        bufferParameters.setJoinStyle(1);
                        continue;
                    }
                    throw new IllegalArgumentException("Supported join values are bevel, mitre, miter or round.");
                }
                if (keyValue[0].equalsIgnoreCase("mitre_limit") || keyValue[0].equalsIgnoreCase("miter_limit")) {
                    bufferParameters.setMitreLimit(Double.valueOf(keyValue[1]).doubleValue());
                    continue;
                }
                if (keyValue[0].equalsIgnoreCase("quad_segs")) {
                    bufferParameters.setQuadrantSegments(Integer.valueOf(keyValue[1]).intValue());
                    continue;
                }
                throw new IllegalArgumentException("Unknown parameters. Please read the documentation.");
            }
            BufferOp bufOp = new BufferOp(geom, bufferParameters);
            return bufOp.getResultGeometry(distance.doubleValue());
        }
        if (value instanceof ValueInt) {
            BufferOp bufOp = new BufferOp(geom, new BufferParameters(value.getInt()));
            return bufOp.getResultGeometry(distance.doubleValue());
        }
        throw new IllegalArgumentException("The third argument must be an int or a varchar.");
    }
}

