/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.validator.functions;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.iom.IomObject;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.Validator;
import ch.interlis.iox_j.validator.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class ElementsFunctions {
    private static final String FUNCTION_VALUES_OF_PATH = "valuesOfPath";
    private static final String FUNCTION_VALUES_OF_PATH_N = "valuesOfPathN";
    private static final String FUNCTION_VALUES_OF_PATH_ANY_STRUCTURE = "valuesOfPathAnyStructure";
    private static final String FUNCTION_EXISTS_IN_LIST = "existsInList";
    private static final String FUNCTION_EXISTS_IN_LIST_N = "existsInListN";
    private static final String FUNCTION_VALUES = "values";
    private static final String FUNCTION_VALUES_N = "valuesN";
    private static final String FUNCTION_COALESCE = "coalesce";
    private static final String FUNCTION_COALESCE_N = "coalesceN";
    private static final String FUNCTION_CONCAT = "concat";
    public static final String ELEMENTS_V1_0 = "Elements_V1_0";
    private final TransferDescription td;
    private final IoxValidationConfig validationConfig;
    private final Validator validator;
    private final LogEventFactory logger;

    public ElementsFunctions(Validator validator, TransferDescription td, IoxValidationConfig validationConfig, LogEventFactory logger) {
        this.validator = validator;
        this.td = td;
        this.validationConfig = validationConfig;
        this.logger = logger;
        logger.setValidationConfig(validationConfig);
    }

    public Value evaluateFunction(Function currentFunction, FunctionCall functionCallObj, IomObject parentObject, String validationKind, String usageScope, IomObject iomObj, RoleDef firstRole) {
        Evaluable[] arguments = functionCallObj.getArguments();
        Value[] actualArguments = new Value[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Value result = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[i], firstRole);
            if (result.skipEvaluation()) {
                return result;
            }
            actualArguments[i] = result;
        }
        if (currentFunction.getName().equals(FUNCTION_VALUES_OF_PATH)) {
            return this.evaluateValuesOfPath(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals(FUNCTION_VALUES_OF_PATH_N)) {
            return this.evaluateValuesOfPath(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals(FUNCTION_VALUES_OF_PATH_ANY_STRUCTURE)) {
            return this.evaluateValuesOfPathAnyStructure(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals(FUNCTION_EXISTS_IN_LIST)) {
            return this.evaluateExistsInList(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals(FUNCTION_EXISTS_IN_LIST_N)) {
            return this.evaluateExistsInList(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals(FUNCTION_VALUES)) {
            return this.evaluateValues(validationKind, usageScope, iomObj, actualArguments, new TextType());
        }
        if (currentFunction.getName().equals(FUNCTION_VALUES_N)) {
            return this.evaluateValues(validationKind, usageScope, iomObj, actualArguments, new NumericType());
        }
        if (currentFunction.getName().equals(FUNCTION_COALESCE)) {
            return this.evaluateCoalesce(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals(FUNCTION_COALESCE_N)) {
            return this.evaluateCoalesce(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals(FUNCTION_CONCAT)) {
            return this.evaluateConcat(validationKind, usageScope, iomObj, actualArguments);
        }
        return Value.createNotYetImplemented();
    }

    private Value evaluateValuesOfPath(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        if (actualArguments[0].isUndefined()) {
            return Value.createUndefined();
        }
        String attrPathArg = actualArguments[0].getValue();
        Viewable currentClass = (Viewable)this.td.getElement(mainObj.getobjecttag());
        PathEl[] attrPath = null;
        ObjectPath attrObjPath = null;
        try {
            attrObjPath = this.validator.parseObjectOrAttributePath(currentClass, attrPathArg);
            if (attrObjPath.getPathElements() != null) {
                PathEl[] surfaceAttrPathEl;
                attrPath = surfaceAttrPathEl = attrObjPath.getPathElements();
            }
        }
        catch (Ili2cException e) {
            EhiLogger.logError(e);
        }
        Value valueOfObjectPath = this.validator.getValueFromObjectPath(null, mainObj, attrPath, null);
        return valueOfObjectPath;
    }

    private Value evaluateValuesOfPathAnyStructure(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        Value argObjects = actualArguments[0];
        Value argPath = actualArguments[1];
        if (argObjects.isUndefined() || argPath.isUndefined() || argObjects.getComplexObjects() == null || argObjects.getComplexObjects().isEmpty()) {
            return Value.createUndefined();
        }
        Collection<IomObject> inputObjects = argObjects.getComplexObjects();
        String inputAttrPath = argPath.getValue();
        Viewable contextClass = (Viewable)this.td.getElement(inputObjects.iterator().next().getobjecttag());
        PathEl[] attrPath = null;
        try {
            ObjectPath attrObjPath = this.validator.parseObjectOrAttributePath(contextClass, inputAttrPath);
            if (attrObjPath.getPathElements() != null) {
                attrPath = attrObjPath.getPathElements();
            }
        }
        catch (Ili2cException e) {
            EhiLogger.logError(e);
        }
        ArrayList<IomObject> resultObjects = new ArrayList<IomObject>();
        for (IomObject obj : inputObjects) {
            Value valueOfObjectPath = this.validator.getValueFromObjectPath(null, obj, attrPath, null);
            if (valueOfObjectPath.getComplexObjects() == null) continue;
            resultObjects.addAll(valueOfObjectPath.getComplexObjects());
        }
        return new Value(resultObjects);
    }

    private Value evaluateExistsInList(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        if (actualArguments[0].isUndefined()) {
            return Value.createUndefined();
        }
        if (actualArguments[1].isUndefined()) {
            return new Value(false);
        }
        String valueArg = actualArguments[0].getValue();
        Value listArg = actualArguments[1];
        if (listArg.getValues() != null) {
            Object[] values = listArg.getValues();
            Arrays.sort(values);
            if (Arrays.binarySearch(values, valueArg) >= 0) {
                return new Value(true);
            }
        } else if (listArg.getValue() != null && valueArg.equals(listArg.getValue())) {
            return new Value(true);
        }
        return new Value(false);
    }

    private Value evaluateValues(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments, Type type) {
        if (actualArguments[0].isUndefined()) {
            return Value.createUndefined();
        }
        String listArg = actualArguments[0].getValue();
        String[] values = listArg.split(";");
        Value ret = new Value(type, values);
        return ret;
    }

    private Value evaluateCoalesce(String validationKind, String usageScope, IomObject iomObj, Value[] actualArguments) {
        Value input = actualArguments[0];
        Value defaultValue = actualArguments[1];
        if (input.isUndefined()) {
            return defaultValue;
        }
        return input;
    }

    private Value evaluateConcat(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        Value argFirstCollection = actualArguments[0];
        Value argSecondCollection = actualArguments[1];
        if (argFirstCollection.isUndefined()) {
            return argSecondCollection;
        }
        if (argSecondCollection.isUndefined()) {
            return argFirstCollection;
        }
        if (argFirstCollection.getValues() != null) {
            String[] firstCollection = argFirstCollection.getValues();
            String[] secondCollection = argSecondCollection.getValues();
            String[] combinedObjects = new String[firstCollection.length + secondCollection.length];
            System.arraycopy(firstCollection, 0, combinedObjects, 0, firstCollection.length);
            System.arraycopy(secondCollection, 0, combinedObjects, firstCollection.length, secondCollection.length);
            return new Value(null, combinedObjects);
        }
        Collection<IomObject> firstCollection = argFirstCollection.getComplexObjects();
        Collection<IomObject> secondCollection = argSecondCollection.getComplexObjects();
        ArrayList<IomObject> combinedObjects = new ArrayList<IomObject>(firstCollection);
        combinedObjects.addAll(secondCollection);
        return new Value(combinedObjects);
    }
}

