/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.validator;

import ch.ehi.basics.types.OutParam;
import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.ehi.iox.objpool.impl.IomObjectSerializer;
import ch.ehi.iox.objpool.impl.ObjPoolImpl2;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iox.IoxLogging;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.ObjectPoolKey;
import ch.interlis.iox_j.validator.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ObjectPool {
    private boolean doItfOidPerTable;
    private HashMap<String, Object> tag2class;
    private ObjectPoolManager objPoolManager = null;
    private Map<String, Map<ObjectPoolKey, IomObject>> collectionOfBaskets = new HashMap<String, Map<ObjectPoolKey, IomObject>>();
    private TreeSet<String> dataBids = new TreeSet();
    private TreeSet<String> refdataBids = new TreeSet();

    public ObjectPool(boolean doItfOidPerTable, IoxLogging errs, LogEventFactory errFact, HashMap<String, Object> tag2class, ObjectPoolManager objPoolManager) {
        this.doItfOidPerTable = doItfOidPerTable;
        this.tag2class = tag2class;
        this.objPoolManager = objPoolManager;
    }

    public static String getAssociationId(IomObject iomObj, AssociationDef assocDef) {
        if (assocDef == null) {
            throw new IllegalArgumentException("assocDef==null");
        }
        String tag = assocDef.getScopedName((Container)null);
        String tid = null;
        Iterator<ViewableTransferElement> rolei = assocDef.getAttributesAndRoles2();
        tid = tag;
        boolean missingRef = false;
        while (rolei.hasNext()) {
            ViewableTransferElement prop = rolei.next();
            if (!(prop.obj instanceof RoleDef) || prop.embedded) continue;
            String roleName = ((RoleDef)prop.obj).getName();
            IomObject refObj = iomObj.getattrobj(roleName, 0);
            String ref = null;
            if (refObj != null) {
                ref = refObj.getobjectrefoid();
            }
            if (ref != null) {
                tid = tid + ":" + ref;
                continue;
            }
            missingRef = true;
        }
        if (missingRef) {
            return null;
        }
        return tid;
    }

    public IomObject addObject(IomObject iomObj, String currentBasketId) {
        Domain oidType;
        String oid = iomObj.getobjectoid();
        Object modelEle = this.tag2class.get(iomObj.getobjecttag());
        ObjectPoolKey key = null;
        if (oid == null) {
            oid = ObjectPool.getAssociationId(iomObj, (AssociationDef)modelEle);
            if (oid == null) {
                throw new IllegalStateException("Association with missing REF " + iomObj.getobjecttag());
            }
        } else if (modelEle instanceof AbstractClassDef && (oidType = ((AbstractClassDef)modelEle).getOid()) == PredefinedModel.getInstance().UUIDOID) {
            oid = Validator.normalizeUUID(oid);
        }
        key = this.doItfOidPerTable ? new ObjectPoolKey(oid, (Viewable)modelEle, currentBasketId) : new ObjectPoolKey(oid, null, currentBasketId);
        Map<ObjectPoolKey, IomObject> collectionOfObjects = null;
        collectionOfObjects = this.getCollectionOfObjects(currentBasketId);
        if (collectionOfObjects.containsKey(key)) {
            return collectionOfObjects.get(key);
        }
        OutParam<String> bidOfTargetObj = new OutParam<String>();
        ArrayList<Viewable> destinationClasses = new ArrayList<Viewable>();
        destinationClasses.add((Viewable)modelEle);
        IomObject existingObj = this.getObject(oid, destinationClasses, bidOfTargetObj);
        if (existingObj != null) {
            return existingObj;
        }
        collectionOfObjects.put(key, iomObj);
        return null;
    }

    private Map<ObjectPoolKey, IomObject> getCollectionOfObjects(String basketId) {
        Map<ObjectPoolKey, IomObject> collectionOfObjects;
        if (basketId == null || basketId.length() == 0) {
            throw new IllegalArgumentException("basketId==null");
        }
        if (this.collectionOfBaskets.containsKey(basketId)) {
            collectionOfObjects = this.collectionOfBaskets.get(basketId);
        } else {
            collectionOfObjects = this.objPoolManager.newObjectPoolImpl2(this.getClass().getSimpleName(), new IomObjectSerializer());
            this.collectionOfBaskets.put(basketId, collectionOfObjects);
        }
        return collectionOfObjects;
    }

    public ObjPoolImpl2 getObjectsOfBasketId(String basketId) {
        return (ObjPoolImpl2)this.getCollectionOfObjects(basketId);
    }

    public Set<String> getDataBids() {
        TreeSet<String> ret = new TreeSet<String>();
        ret.addAll(this.dataBids);
        ret.addAll(this.refdataBids);
        return ret;
    }

    public Set<String> getOnlyDataBids() {
        return this.dataBids;
    }

    public String getBidOfObject(String oid, Viewable classObj) {
        Domain oidType;
        if (classObj instanceof AbstractClassDef && (oidType = ((AbstractClassDef)classObj).getOid()) == PredefinedModel.getInstance().UUIDOID) {
            oid = Validator.normalizeUUID(oid);
        }
        for (String basketId : this.getDataBids()) {
            IomObject object;
            Map<ObjectPoolKey, IomObject> collectionOfObjects = this.getCollectionOfObjects(basketId);
            if (!(this.doItfOidPerTable ? (object = collectionOfObjects.get(new ObjectPoolKey(oid, classObj, basketId))) != null : (object = collectionOfObjects.get(new ObjectPoolKey(oid, null, basketId))) != null)) continue;
            return basketId;
        }
        return null;
    }

    public IomObject getObject(String oid, ArrayList<Viewable> ili1Tables, OutParam<String> retBasketId) {
        ArrayList<String> bids = new ArrayList<String>();
        bids.addAll(this.dataBids);
        bids.addAll(this.refdataBids);
        for (String basketId : bids) {
            Object modelEle;
            Domain oidType;
            Map<ObjectPoolKey, IomObject> collectionOfObjects = this.getCollectionOfObjects(basketId);
            if (this.doItfOidPerTable) {
                for (Viewable aClass : ili1Tables) {
                    IomObject object = collectionOfObjects.get(new ObjectPoolKey(oid, aClass, basketId));
                    if (object == null) continue;
                    if (retBasketId != null) {
                        retBasketId.value = basketId;
                    }
                    return object;
                }
                continue;
            }
            IomObject object = collectionOfObjects.get(new ObjectPoolKey(oid, null, basketId));
            if (object == null && (object = collectionOfObjects.get(new ObjectPoolKey(Validator.normalizeUUID(oid), null, basketId))) != null && (oidType = ((AbstractClassDef)(modelEle = this.tag2class.get(object.getobjecttag()))).getOid()) != PredefinedModel.getInstance().UUIDOID) {
                object = null;
            }
            if (object == null) continue;
            if (retBasketId != null) {
                retBasketId.value = basketId;
            }
            return object;
        }
        if (retBasketId != null) {
            retBasketId.value = null;
        }
        return null;
    }

    public void startNewTransfer() {
    }

    public void startBasket(String basketId, boolean doValidation) {
        if (basketId == null || basketId.length() == 0) {
            throw new IllegalArgumentException("basketId==null");
        }
        if (doValidation) {
            this.dataBids.add(basketId);
        } else {
            this.refdataBids.add(basketId);
        }
    }
}

