/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.plugins;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.tools.StringUtility;
import ch.interlis.iox_j.plugins.IoxPlugin;
import ch.interlis.iox_j.plugins.PluginLoader;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

class JARClassLoader
extends URLClassLoader {
    public static final String IOX_CLASS_PATH = "iox-class-path";
    private ArrayList<String> pluginClassnames = new ArrayList();
    private String pluginClassPath = null;
    private String pluginPath = null;

    public JARClassLoader(String path) throws IOException {
        super(new URL[]{new URL("file", "", path)});
        this.pluginPath = path;
        URL u = new URL("jar", "", new URL("file", "", path) + "!/");
        JarURLConnection uc = (JarURLConnection)u.openConnection();
        JarFile jarFile = uc.getJarFile();
        Enumeration<JarEntry> entires = jarFile.entries();
        while (entires.hasMoreElements()) {
            ZipEntry entry = entires.nextElement();
            String name = entry.getName();
            if (!name.endsWith("IoxPlugin.class")) continue;
            name = JARClassLoader.fileToClass(name);
            this.pluginClassnames.add(name);
        }
        Manifest manifest = jarFile.getManifest();
        Attributes attrs = manifest.getMainAttributes();
        this.pluginClassPath = StringUtility.purge(attrs.getValue(IOX_CLASS_PATH));
    }

    public boolean isIoxPluginJar() {
        return !this.pluginClassnames.isEmpty();
    }

    void loadAllPlugins(PluginLoader pluginLoader) {
        EhiLogger.traceState("load plugins from <" + this.pluginPath + ">");
        for (int i = 0; i < this.pluginClassnames.size(); ++i) {
            String name = this.pluginClassnames.get(i);
            try {
                Class<?> clazz = this.loadClass(name);
                IoxPlugin plugin = (IoxPlugin)clazz.newInstance();
                pluginLoader.addPlugin(plugin);
                continue;
            }
            catch (Throwable t) {
                EhiLogger.logError("Error while starting plugin " + name, t);
            }
        }
    }

    public static String fileToClass(String name) {
        char[] clsName = name.toCharArray();
        for (int i = clsName.length - 6; i >= 0; --i) {
            if (clsName[i] != '/') continue;
            clsName[i] = 46;
        }
        return new String(clsName, 0, clsName.length - 6);
    }

    public void loadDependencies() throws IOException {
        if (this.pluginClassPath != null) {
            String[] dependents;
            String basePath = new File(this.pluginPath).getParent();
            for (String dependent : dependents = this.pluginClassPath.split(" ")) {
                dependent = basePath + "/" + dependent;
                EhiLogger.traceState("load plugin lib <" + dependent + ">");
                this.addURL(new URL("file", "", dependent));
            }
        }
    }
}

