/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.iox.adddefval;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.iox.adddefval.ReferencedTextLength;
import ch.ehi.iox.adddefval.TargetObjects;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Constant;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.LengthOfReferencedText;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.ili2c.parser.Ili1Undef;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.EnumCodeMapper;
import java.util.HashMap;
import java.util.Iterator;

public class Converter {
    private HashMap defvalueSettings = new HashMap();
    private HashMap textTables = new HashMap();
    private boolean readEnumValAsItfCode = false;
    private EnumCodeMapper enumTypes = new EnumCodeMapper();

    public Converter(TransferDescription td) {
        this(td, false);
    }

    public Converter(TransferDescription td, boolean readEnumValAsItfCode) {
        this.readEnumValAsItfCode = readEnumValAsItfCode;
        Iterator modeli = td.iterator();
        while (modeli.hasNext()) {
            Object modelo = modeli.next();
            if (!(modelo instanceof Model)) continue;
            Model model = (Model)modelo;
            Iterator topici = model.iterator();
            while (topici.hasNext()) {
                Object topico = topici.next();
                if (!(topico instanceof Topic)) continue;
                Topic topic = (Topic)topico;
                Iterator tablei = topic.iterator();
                while (tablei.hasNext()) {
                    Object tableo = tablei.next();
                    if (!(tableo instanceof AbstractClassDef)) continue;
                    AbstractClassDef table = (AbstractClassDef)tableo;
                    this.visitAbstractClassDef(table);
                }
            }
        }
    }

    private void visitAbstractClassDef(AbstractClassDef table) {
        ViewableTransferElement attro;
        RoleDef refAttr = null;
        Iterator<ViewableTransferElement> attri = table.getAttributesAndRoles2();
        while (attri.hasNext()) {
            attro = attri.next();
            if (attro.obj instanceof AttributeDef || !(attro.obj instanceof RoleDef)) continue;
            refAttr = (RoleDef)attro.obj;
            break;
        }
        attri = table.getAttributesAndRoles2();
        while (attri.hasNext()) {
            AttributeDef attr;
            String expl;
            attro = attri.next();
            if (!(attro.obj instanceof AttributeDef) || (expl = (attr = (AttributeDef)attro.obj).getExplanation()) == null || !expl.trim().startsWith("undefiniert")) continue;
            if (attr.getDomain().isMandatory()) {
                EhiLogger.logAdaption(attr.toString() + ": mandatory attribute; default value statement ignored (" + expl + ")");
                continue;
            }
            Evaluable value = Ili1Undef.parseValueIfUndefined(attr.toString(), expl);
            if (value == null) continue;
            if (value instanceof LengthOfReferencedText && refAttr == null) {
                EhiLogger.logAdaption(attr.toString() + ": no reference attribute in table; default value statement ignored (" + expl + ")");
                continue;
            }
            this.addDefValue(table, attr, refAttr, value);
        }
    }

    private void addDefValue(AbstractClassDef table, AttributeDef attr, RoleDef refattr, Evaluable value) {
        String className = table.getScopedName((Container)null);
        HashMap defvalues = null;
        if (this.defvalueSettings.containsKey(className)) {
            defvalues = (HashMap)this.defvalueSettings.get(className);
        } else {
            defvalues = new HashMap();
            this.defvalueSettings.put(className, defvalues);
        }
        if (value instanceof Constant.Enumeration) {
            String[] vals = ((Constant.Enumeration)value).getValue();
            StringBuffer val = new StringBuffer();
            String sep = "";
            for (int i = 0; i < vals.length; ++i) {
                val.append(sep);
                val.append(vals[i]);
                sep = ".";
            }
            String v = val.toString();
            Type type = attr.getDomainResolvingAliases();
            String itfCode = v;
            if (this.readEnumValAsItfCode && (itfCode = this.enumTypes.mapXtfCode2ItfCode((EnumerationType)type, v)) == null) {
                EhiLogger.logAdaption(className + " : unexpected default value <" + v + "> for attribute " + attr.getName() + "; read without default value");
                itfCode = v;
            }
            defvalues.put(attr.getName(), itfCode);
        } else if (value instanceof Constant.Numeric) {
            String v = ((Constant.Numeric)value).getValue().toIli1String();
            defvalues.put(attr.getName(), v);
        } else if (value instanceof Constant.Text) {
            String v = ((Constant.Text)value).getValue();
            defvalues.put(attr.getName(), v);
        } else if (value instanceof LengthOfReferencedText) {
            if (refattr == null) {
                throw new IllegalArgumentException("no reference attribute");
            }
            TargetObjects targetObjects = this.addTarget(refattr.getDestination());
            ReferencedTextLength v = null;
            v = new ReferencedTextLength();
            v.setRefattr(refattr);
            v.setTargetObjects(targetObjects);
            defvalues.put(attr.getName(), v);
        } else {
            throw new IllegalArgumentException(value.getClass().getName());
        }
    }

    private TargetObjects addTarget(AbstractClassDef table) {
        String className = table.getScopedName((Container)null);
        if (this.textTables.containsKey(className)) {
            return (TargetObjects)this.textTables.get(className);
        }
        AttributeDef txtAttr = null;
        Iterator<Extendable> attri = table.getAttributes();
        while (attri.hasNext()) {
            AttributeDef attr = (AttributeDef)attri.next();
            if (!(attr.getDomainResolvingAliases() instanceof TextType)) continue;
            txtAttr = attr;
            break;
        }
        if (txtAttr == null) {
            throw new IllegalArgumentException("no TEXT attribute in table " + table.getScopedName((Container)null));
        }
        TargetObjects targetObjects = new TargetObjects(txtAttr);
        this.textTables.put(className, targetObjects);
        return targetObjects;
    }

    public void convert(IomObject iomObj) {
        String className = iomObj.getobjecttag();
        if (this.defvalueSettings.containsKey(className)) {
            HashMap defvalues = (HashMap)this.defvalueSettings.get(className);
            for (String attr : defvalues.keySet()) {
                String refAttr;
                String ref;
                if (iomObj.getattrvalue(attr) != null) continue;
                Object valueo = defvalues.get(attr);
                if (valueo instanceof String) {
                    iomObj.setattrvalue(attr, (String)valueo);
                    continue;
                }
                if (!(valueo instanceof ReferencedTextLength)) continue;
                ReferencedTextLength refLen = (ReferencedTextLength)valueo;
                TargetObjects targetObjects = refLen.getTargetObjects();
                String value = targetObjects.getTextLength(ref = this.getRef(iomObj, refAttr = refLen.getRefattr().getName()));
                if (value == null) {
                    EhiLogger.logError(className + " " + iomObj.getobjectoid() + ": dangling reference (attribute " + refAttr + "=" + ref + ")");
                    continue;
                }
                if (value.equals("@")) continue;
                iomObj.setattrvalue(attr, value);
            }
        }
        if (this.textTables.containsKey(className)) {
            TargetObjects targetObjs = (TargetObjects)this.textTables.get(className);
            String txtAttr = targetObjs.getTxtAttr().getName();
            String txt = iomObj.getattrvalue(txtAttr);
            String txtLen = "@";
            if (txt != null) {
                txtLen = Integer.toString(txt.length());
            }
            targetObjs.setTextLength(iomObj.getobjectoid(), txtLen);
        }
    }

    private String getRef(IomObject iomObj, String refAttr) {
        IomObject ref = iomObj.getattrobj(refAttr, 0);
        if (ref == null) {
            return null;
        }
        return ref.getobjectrefoid();
    }
}

