/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.geovalid;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.ErrorTracker;
import ch.ehi.basics.logging.FileListener;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.Ili2c;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.Ili2cFailure;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.iom_j.itf.ItfReader;
import ch.interlis.iom_j.itf.ItfReader2;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iox.EndBasketEvent;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox_j.IoxInvalidDataException;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class GeovalidTool {
    public static final String SETTING_ILIDIRS = "ch.ehi.geovalid.ilidirs";
    public static final String SETTING_DIRUSED = "ch.ehi.geovalid.dirused";
    public static final String ITF_DIR = "%ITF_DIR";
    public static final String JAR_DIR = "%JAR_DIR";
    public static final String APP_NAME = "geovalid";
    public static final String APP_JAR = "geovalid.jar";
    private static String version = null;
    private static final String SETTINGS_FILE = System.getProperty("user.home") + "/.geovalid";

    public static void main(String[] args) {
        GeovalidTool p = new GeovalidTool();
        p.mymain(args);
    }

    public void mymain(String[] args) {
        int argi;
        Settings settings = new Settings();
        settings.setValue(SETTING_ILIDIRS, "%ITF_DIR;http://models.interlis.ch/;%JAR_DIR");
        String logfile = null;
        boolean doGui = false;
        for (argi = 0; argi < args.length; ++argi) {
            String arg = args[argi];
            if (arg.equals("--trace")) {
                EhiLogger.getInstance().setTraceFilter(false);
                continue;
            }
            if (arg.equals("--version")) {
                GeovalidTool.printVersion();
                return;
            }
            if (arg.equals("--ilidirs")) {
                settings.setValue(SETTING_ILIDIRS, args[++argi]);
                continue;
            }
            if (arg.equals("--log")) {
                logfile = args[++argi];
                continue;
            }
            if (arg.equals("--help")) {
                GeovalidTool.printHelp(settings);
                return;
            }
            if (!arg.startsWith("-")) break;
            EhiLogger.logAdaption(arg + ": unknown option; ignored");
        }
        if (argi == args.length) {
            GeovalidTool.printHelp(settings);
            return;
        }
        String itffile = args[argi++];
        this.run(itffile, logfile, settings);
    }

    public static void readSettings(Settings settings) {
        File file = new File(SETTINGS_FILE);
        try {
            if (file.exists()) {
                settings.load(file);
            }
        }
        catch (IOException ex) {
            EhiLogger.logError("failed to load settings from file " + SETTINGS_FILE, ex);
        }
    }

    public static void writeSettings(Settings settings) {
        File file = new File(SETTINGS_FILE);
        try {
            settings.store(file, "geovalid settings");
        }
        catch (IOException ex) {
            EhiLogger.logError("failed to settings settings to file " + SETTINGS_FILE, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String itffile, String logfile, Settings settings) {
        ErrorTracker tracker = new ErrorTracker();
        EhiLogger.getInstance().addListener(tracker);
        try {
            try {
                EhiLogger.logState("validating...");
                this.prun(itffile, logfile, settings);
            }
            catch (Throwable ex) {
                EhiLogger.logError(ex);
            }
            if (tracker.hasSeenErrors()) {
                EhiLogger.logState("validating...failed");
            } else {
                EhiLogger.logState("validating...succeeded");
            }
        }
        finally {
            EhiLogger.getInstance().removeListener(tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prun(String itffile, String logfile, Settings settings) throws IoxException {
        ArrayList<String> models;
        FileListener logger = null;
        if (logfile != null) {
            logger = new FileListener(new File(logfile), true);
            EhiLogger.getInstance().addListener(logger);
        }
        EhiLogger.logState("geovalid-" + GeovalidTool.getVersion());
        EhiLogger.logState("ili2c-" + Ili2c.getVersion());
        EhiLogger.logState("itffile <" + itffile + ">");
        if (logfile != null) {
            EhiLogger.logState("logfile <" + logfile + ">");
        }
        ArrayList<String> modeldirv = new ArrayList<String>();
        String ilidirs = settings.getValue(SETTING_ILIDIRS);
        EhiLogger.logState("ilidirs <" + ilidirs + ">");
        String[] modeldirs = ilidirs.split(";");
        HashSet ilifiledirs = new HashSet();
        for (int modeli = 0; modeli < modeldirs.length; ++modeli) {
            String m = modeldirs[modeli];
            if (m.equals(ITF_DIR)) {
                String ilifile = itffile;
                m = new File(ilifile).getAbsoluteFile().getParentFile().getAbsolutePath();
                if (m == null || m.length() <= 0 || modeldirv.contains(m)) continue;
                modeldirv.add(m);
                continue;
            }
            if (m.equals(JAR_DIR)) {
                m = GeovalidTool.getAppHome();
                if (m != null) {
                    m = new File(m, "ilimodels").getAbsolutePath();
                }
                if (m == null || m.length() <= 0) continue;
                modeldirv.add(m);
                continue;
            }
            if (m == null || m.length() <= 0) continue;
            modeldirv.add(m);
        }
        TransferDescription td = null;
        Configuration ili2cConfig = null;
        ArrayList<String> modelv = new ArrayList<String>();
        String xmlfile = itffile;
        try {
            models = GeovalidTool.getModels(new File(itffile));
        }
        catch (IoxException ex) {
            EhiLogger.logError("failed to detect model of file " + xmlfile, ex);
            return;
        }
        if (models.size() == 0) {
            EhiLogger.logError("failed to detect model of file " + xmlfile);
            return;
        }
        modelv.addAll(models);
        try {
            IliManager modelManager = new IliManager();
            modelManager.setRepositories(modeldirv.toArray(new String[0]));
            ili2cConfig = modelManager.getConfig(modelv, 0.0);
            ili2cConfig.setGenerateWarnings(false);
        }
        catch (Ili2cException ex) {
            EhiLogger.logError(ex);
            return;
        }
        try {
            Ili2c.logIliFiles(ili2cConfig);
            td = Ili2c.runCompiler(ili2cConfig);
        }
        catch (Ili2cFailure ex) {
            EhiLogger.logError(ex);
            return;
        }
        HashMap itfNames = ModelUtilities.getTagMap(td);
        ItfReader2 reader = null;
        long startTime = System.currentTimeMillis();
        try {
            IoxEvent event;
            reader = new ItfReader2(new File(itffile), false);
            reader.setModel(td);
            Object currentTablename = null;
            StartBasketEvent basket = null;
            do {
                ArrayList<IoxInvalidDataException> dataerrs;
                if ((event = reader.read()) instanceof StartBasketEvent) {
                    basket = (StartBasketEvent)event;
                    EhiLogger.logState("Basket " + basket.getType() + "(oid " + basket.getBid() + ")...");
                    continue;
                }
                if (!(event instanceof EndBasketEvent) || (dataerrs = reader.getDataErrs()).size() <= 0) continue;
                for (IoxInvalidDataException dataerr : dataerrs) {
                    EhiLogger.logError(dataerr);
                }
                reader.clearDataErrs();
            } while (!(event instanceof EndTransferEvent));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            reader = null;
            if (logger != null) {
                EhiLogger.getInstance().removeListener(logger);
                logger.close();
            }
            logger = null;
        }
        long endTime = System.currentTimeMillis();
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        EhiLogger.traceState("duration " + (endTime - startTime) + " ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getModels(File itffile) throws IoxException {
        ArrayList<String> ret = new ArrayList<String>();
        ItfReader reader = null;
        try {
            IoxEvent event;
            reader = new ItfReader(itffile);
            while ((event = reader.read()) != null) {
                if (!(event instanceof StartBasketEvent)) continue;
                String topic = ((StartBasketEvent)event).getType();
                String[] model = topic.split("\\.");
                ret.add(model[0]);
                ArrayList<String> arrayList = ret;
                return arrayList;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            reader = null;
        }
        return ret;
    }

    private static void printHelp(Settings settings) {
        GeovalidTool.printVersion();
        System.err.println();
        GeovalidTool.printDescription();
        System.err.println();
        GeovalidTool.printUsage();
        System.err.println();
        System.err.println("OPTIONS");
        System.err.println();
        System.err.println("--ilidirs " + settings.getValue(SETTING_ILIDIRS) + " list of directories with ili-files.");
        System.err.println("--log filename         log message to given file.");
        System.err.println("--trace                enable trace messages.");
        System.err.println("--help                 Display this help text.");
        System.err.println("--version              Display the version of geovalid.");
        System.err.println();
    }

    protected static void printVersion() {
        System.err.println("geovalid, Version " + GeovalidTool.getVersion());
        System.err.println("  Developed by Eisenhut Informatik AG, CH-3401 Burgdorf");
    }

    protected static void printDescription() {
        System.err.println("DESCRIPTION");
        System.err.println("  Validates INTERLIS transfer files.");
    }

    protected static void printUsage() {
        System.err.println("USAGE");
        System.err.println("  java -jar geovalid.jar [Options] data.itf");
    }

    public static String getVersion() {
        if (version == null) {
            java.util.ResourceBundle resVersion = java.util.ResourceBundle.getBundle(ResourceBundle.class2qpackageName(GeovalidTool.class) + "/Version");
            StringBuffer ret = new StringBuffer(20);
            ret.append(resVersion.getString("versionMajor"));
            ret.append('.');
            ret.append(resVersion.getString("versionMinor"));
            ret.append('.');
            ret.append(resVersion.getString("versionMicro"));
            ret.append('-');
            ret.append(resVersion.getString("versionDate"));
            version = ret.toString();
        }
        return version;
    }

    public static String getAppHome() {
        int start;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf(APP_JAR);
        if (index > (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            return classpath.substring(start, index - 1);
        }
        return null;
    }
}

